/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bod.cmp.service.balance;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bod.cmp.service.Packer;
import kd.ebg.aqap.banks.bod.cmp.service.Parser;
import kd.ebg.aqap.banks.bod.cmp.utils.BOD_CMPUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        Element root = Packer.createHead("200108", request.getHeader().getRequestSeqID());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        String xmlMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlMessage);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parserHead(root);
        if (!"0".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
        }
        Element body = root.getChild("body");
        if (null == body.getChildren() || body.getChildren().size() == 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\u3002\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e2dbody\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]));
        }
        String accountNo = body.getChildTextTrim("acno");
        String currency = body.getChildTextTrim("cur_code");
        String balance = body.getChildTextTrim("balance");
        String availableBalance = body.getChildTextTrim("use_balance");
        BalanceInfo balanceInfo = new BalanceInfo();
        this.setBankAcnt(balanceInfo, request.getBankAcntList(), accountNo);
        this.setBankCurrency(balanceInfo, request.getBankCurrency(), currency);
        this.setCurrentBalance(balanceInfo, balance);
        this.setAvailableBalance(balanceInfo, availableBalance);
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "qiang";
    }

    public String getBizCode() {
        return "200108";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_6", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return BOD_CMPUtils.parseRecvMsg(super.recv(inputStream));
    }

    public void configFactory(ConnectionFactory factory) {
        factory.addHeader("Content-Type", "application/x-www-form-urlencoded");
    }
}

