/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bod.cmp.service.payment.batch;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bod.cmp.service.Packer;
import kd.ebg.aqap.banks.bod.cmp.service.Parser;
import kd.ebg.aqap.banks.bod.cmp.service.ProxyUpload;
import kd.ebg.aqap.banks.bod.cmp.service.payment.batch.BatchQueryPayImpl;
import kd.ebg.aqap.banks.bod.cmp.utils.BOD_CMPUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchPayImpl
extends AbstractPayImpl
implements IPay {
    private static final String BATCHFILEHEDAER = "cert_type|cert_no|rcv_acno|rcv_cur_code|rcv_acname|rcv_accaddr|amt|as_flag|as_acno|as_acname|rcv_bank_no|rcv_bank_name|bank_flag|area_flag|urgency_flag|purpose|postscript|booking_flag|booking_date|booking_time|mobiles|saverecvinfo_flag|";

    public void configFactory(ConnectionFactory factory) {
        factory.addHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return BatchQueryPayImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "300006";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u5bf9\u5916\u652f\u4ed8", (String)"BatchPayImpl_0", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        if ("pay".equalsIgnoreCase(paymentInfo.getSubBizType())) {
            return paymentInfo.getTotalCount() > 1 && paymentInfo.is2SameBank();
        }
        if ("pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType())) {
            return !UseConvertor.isSalary((PaymentInfo)paymentInfo);
        }
        return false;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = Packer.createHead("300006", ((PaymentInfo)paymentInfos.get(0)).getPackageId(), true);
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)((PaymentInfo)paymentInfos.get(0)).getPackageId());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)((PaymentInfo)paymentInfos.get(0)).getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)((PaymentInfo)paymentInfos.get(0)).getAccName());
        Element totalAmtElement = JDomUtils.addChild((Element)body, (String)"amt");
        JDomUtils.addChild((Element)body, (String)"count", (String)String.valueOf(paymentInfos.size()));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation());
        String fileName = "batch_pay_" + ((PaymentInfo)paymentInfos.get(0)).getPackageId() + ".txt";
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        StringBuilder fileTextBuffer = new StringBuilder();
        fileTextBuffer.append(BATCHFILEHEDAER);
        fileTextBuffer.append("\r\n");
        BigDecimal totalAmt = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            totalAmt = totalAmt.add(((PaymentInfo)paymentInfos.get(i)).getAmount());
            fileTextBuffer.append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqID()).append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo()).append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getCurrency()).append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getIncomeAccName()).append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getIncomeBankAddress()).append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getAmount().setScale(2, 1).toString()).append('|');
            fileTextBuffer.append('0').append('|');
            fileTextBuffer.append('|');
            fileTextBuffer.append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getIncomeCnaps()).append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getIncomeBankName()).append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).is2SameBank() ? "0" : "1").append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).is2SameCity() ? "0" : "1").append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).is2Urgent() ? "1" : "0").append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getExplanation()).append('|');
            fileTextBuffer.append('|');
            fileTextBuffer.append('0').append('|');
            fileTextBuffer.append('|');
            fileTextBuffer.append('|');
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getMobiles()).append('|');
            fileTextBuffer.append('|');
            fileTextBuffer.append("\r\n");
        }
        totalAmtElement.setText(totalAmt.setScale(2, 1).toString());
        String encoding = RequestContextUtils.getCharset();
        String xmlMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        ProxyUpload proxyUpload = new ProxyUpload(fileTextBuffer.toString());
        if (!proxyUpload.doBiz(fileName)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u8bf7\u6c42\u5931\u8d25\u3002", (String)"", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]));
        }
        return Packer.buildCommonMsg(xmlMessage);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        List paymentInfos = request.getPaymentInfos();
        BankResponse rsp = Parser.parserHead(root);
        Element head = root.getChild("head");
        String serialNo = head.getChildText("serial_no");
        if (StringUtils.isEmpty((String)serialNo)) {
            serialNo = "";
        }
        for (PaymentInfo paymentInfo : paymentInfos) {
            paymentInfo.setBankRefID(serialNo);
        }
        if ("0".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String recv(InputStream inputStream) {
        return BOD_CMPUtils.parseRecvMsg(super.recv(inputStream));
    }
}

