/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bod.cmp.service.payment.batch;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bod.cmp.service.Packer;
import kd.ebg.aqap.banks.bod.cmp.service.Parser;
import kd.ebg.aqap.banks.bod.cmp.service.QueryPayProxyDownload;
import kd.ebg.aqap.banks.bod.cmp.utils.BOD_CMPUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(BatchQueryPayImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.addHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public int getBatchSize() {
        return 500;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200202";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u8f6c\u8d26\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2", (String)"BatchQueryPayImpl_0", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return BOD_CMPUtils.parseRecvMsg(super.recv(inputStream));
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = Packer.createHead("200202", request.getHeader().getRequestSeqID());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)((PaymentInfo)paymentInfos.get(0)).getPackageId());
        String serial_no = ((PaymentInfo)paymentInfos.get(0)).getBankRefID();
        if (StringUtils.isEmpty((String)serial_no)) {
            String errorMsg = ResManager.loadKDString((String)"serial_no\u8fd4\u56de\u4e3a\u7a7a\uff0c\u53ef\u80fd\u662f\u63d0\u4ea4\u4ed8\u6b3e\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u548c\u94f6\u884c\u786e\u8ba4\u540e\u518d\u624b\u5de5\u4fee\u6539\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"BatchQueryPayImpl_12", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]);
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)"", (String)errorMsg);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serial_no);
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)RequestContextUtils.getBankParameterValue((String)"CORP_NO"));
        String bankParameterValue = RequestContextUtils.getBankParameterValue((String)"testServerDate");
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)(StringUtils.isEmpty((String)bankParameterValue) ? ((PaymentInfo)paymentInfos.get(0)).getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")) : bankParameterValue));
        String encoding = RequestContextUtils.getCharset();
        String xmlMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return Packer.buildCommonMsg(xmlMessage);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        String data;
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        List paymentInfos = request.getPaymentInfos();
        BankResponse rsp = Parser.parserHead(root);
        if (!"0".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u72b6\u6001\u7801\u4e3a\uff1a%1$s\uff0c\u94f6\u884c\u8fd4\u56de\u7684\u4fe1\u606f\u4e3a\uff1a%2$s\u3002", (String)"BatchQueryPayImpl_10", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element head = root.getChild("head");
        String file_flag = head.getChildTextTrim("file_flag");
        log.info("\u8fd4\u56defile_flag:\u4e3a" + file_flag);
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        if ("0".equals(record_num)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\uff0c\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u8bb0\u5f55\u6570\u4e3a0\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001\u3002", (String)"BatchQueryPayImpl_4", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]));
        }
        if ("1".equals(file_flag)) {
            String file_name = body.getChildTextTrim("file_name");
            QueryPayProxyDownload proxyDownload = new QueryPayProxyDownload();
            data = proxyDownload.doBiz(file_name);
        } else if ("0".equals(file_flag)) {
            data = body.getChildTextTrim("serial_record");
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5,\u94f6\u884c\u8fd4\u56defile_flag\u5b57\u6bb5\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u83b7\u53d6\u4ed8\u6b3e\u6570\u636e.", (String)"BatchQueryPayImpl_5", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]));
        }
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        String[] splits = StringUtils.split((String)data, (String)"|");
        Map<String, PaymentInfo> paymentInfoMap = this.getPaymentInfoMap(paymentInfos);
        for (int i = 1; i <= recordNum; ++i) {
            String STAT = splits[fieldNum * i + 25];
            String ERR_MSG = splits[fieldNum * i + 28];
            String CERT_NO = splits[fieldNum * i + 4];
            PaymentInfo payInfo = paymentInfoMap.getOrDefault(CERT_NO, null);
            if (payInfo == null) {
                log.info("\u7b2c" + i + "\u6761\u4ed8\u6b3e\u6570\u636e\u672a\u5339\u914d\u5230\u4ed8\u6b3e\u8bb0\u5f55\uff0c\u51ed\u8bc1\u53f7\uff1a" + CERT_NO);
                continue;
            }
            if ("6".equals(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"BatchQueryPayImpl_6", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
                continue;
            }
            if ("9".equals(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"BatchQueryPayImpl_7", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]), (String)STAT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"BatchQueryPayImpl_7", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]));
                continue;
            }
            if ("3".equals(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BatchQueryPayImpl_8", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"BatchQueryPayImpl_9", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private Map<String, PaymentInfo> getPaymentInfoMap(List<PaymentInfo> paymentInfoList) {
        HashMap<String, PaymentInfo> map = new HashMap<String, PaymentInfo>(16);
        for (PaymentInfo paymentInfo : paymentInfoList) {
            map.putIfAbsent(paymentInfo.getBankDetailSeqID(), paymentInfo);
        }
        return map;
    }
}

