/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class AcntHelp {
    public static boolean isCashPoolAcnt(String accNo) {
        return "cashpool".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)accNo));
    }

    public static void checkAccCity(PaymentInfo paymentInfo) throws EBServiceException {
        String payerCity = paymentInfo.getAccCity();
        String payeeCity = paymentInfo.getIncomeCity();
        if (StringUtils.isEmpty((String)payerCity)) {
            String accNo = paymentInfo.getAccNo();
            String customID = paymentInfo.getCustomID();
            BankAcntService bankAcntService = BankAcntService.getInstance();
            BankAcnt bankAcnt = bankAcntService.selectByCustomIDAndAccNo(accNo, customID);
            if (bankAcnt == null || StringUtils.isEmpty((String)bankAcnt.getCity())) {
                throw new EBServiceException(String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u94f6\u4f01\u4e91\u7ef4\u62a4\u4ed8\u6b3e\u65b9%1$s(%2$s)\u57ce\u5e02\u4fe1\u606f", (String)"AcntHelp_3", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), accNo, customID));
            }
            paymentInfo.setAccCity(bankAcnt.getCity());
        }
        if (payeeCity == null) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u7f3a\u5c11\u6536\u6b3e\u65b9'\u57ce\u5e02'\u4fe1\u606f", (String)"AcntHelp_2", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]));
        }
    }
}

