/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.banks.cmbc.dc.services.Parser;
import kd.ebg.aqap.banks.cmbc.dc.services.Utils;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceParser {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(HisBalanceParser.class);

    public EBBankBalanceResponse parseHisBalance(BankBalanceRequest rqst, String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseResponse(root);
        Utils.checkRspCode(response, "0");
        Element xDataBody = root.getChild("xDataBody");
        String balance = xDataBody.getChildText("balance");
        String currency = xDataBody.getChildText("currency");
        String acntNo = xDataBody.getChildText("acntNo");
        log.info("\u67e5\u8be2\u4f59\u989d\u8fd4\u56de\u8d26\u53f7:" + acntNo);
        log.info("\u67e5\u8be2\u4f59\u989d\u8fd4\u56de\u5f53\u524d\u4f59\u989d:" + balance);
        BalanceInfo balanceinfo = new BalanceInfo();
        BalanceUtil.setBankAcnt((BalanceInfo)balanceinfo, (List)rqst.getBankAcntList(), (String)acntNo);
        BalanceUtil.setBalanceDateTime((BalanceInfo)balanceinfo, (LocalDateTime)rqst.getStartDate().atStartOfDay());
        BalanceUtil.setBankCurrency((BalanceInfo)balanceinfo, (String)currency);
        BalanceUtil.setCurrentBalance((BalanceInfo)balanceinfo, (String)balance);
        BalanceUtil.setAvailableBalance((BalanceInfo)balanceinfo, (String)balance);
        ArrayList<BalanceInfo> infos = new ArrayList<BalanceInfo>(1);
        infos.add(balanceinfo);
        return new EBBankBalanceResponse(infos);
    }
}

