/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.balance;

import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.AcntHelp;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.balance.fixed.FixedBalancePacker;
import kd.ebg.aqap.banks.cmbc.dc.services.balance.margin.MarginBalancePacker;
import kd.ebg.aqap.banks.cmbc.dc.services.balance.virtual.VirtualTodayBalancePacker;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalancePacker {
    public static String packTodayBalance(BankBalanceRequest rqst) throws EBServiceException {
        if (BankBusinessConfig.isVirtualAccount(rqst.getAcnt().getAccNo())) {
            return VirtualTodayBalancePacker.packTodayBalance(rqst);
        }
        if (AcntHelp.isCashPoolAcnt(rqst.getAcnt().getAccNo())) {
            return TodayBalancePacker.cashPoolBalancePacker(rqst);
        }
        if (BankBusinessConfig.isMarginAccount(rqst.getAcnt().getAccNo())) {
            return MarginBalancePacker.packTodayBalance(rqst);
        }
        if (BankBusinessConfig.isFixedAcnt(rqst.getAcnt().getAccNo())) {
            return FixedBalancePacker.packTodayBalance(rqst);
        }
        Element root = Packer.createMessageWithHead("qryBalNew");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)RequestContextUtils.getRequestContext().getBankRequestSeq());
        Element acntListElements = JDomUtils.addChild((Element)xdataBody, (String)"acntList");
        String reqAccNo = rqst.getAcnt().getAccNo();
        JDomUtils.addChild((Element)acntListElements, (String)"acntNo", (String)reqAccNo);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String cashPoolBalancePacker(BankBalanceRequest rqst) throws EBServiceException {
        Element root = Packer.createMessageWithHead("XJCActFincDetail");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        String accNo = rqst.getAcnt().getAccNo();
        JDomUtils.addChild((Element)xdataBody, (String)"uppAcno", (String)BankBusinessConfig.getUpAccNo(accNo));
        JDomUtils.addChild((Element)xdataBody, (String)"acno", (String)accNo);
        JDomUtils.addChild((Element)xdataBody, (String)"curCode", (String)rqst.getBankCurrency());
        JDomUtils.addChild((Element)xdataBody, (String)"queryFlag", (String)"1");
        JDomUtils.addChild((Element)xdataBody, (String)"beginDate");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }
}

