/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.balance.virtual;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.services.Constants;
import kd.ebg.aqap.banks.cmbc.dc.services.Parser;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class VirtualTodayBalanceParser
implements Constants {
    public static EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseResponse(root);
        ParserUtils.checkRspCode((BankAcnt)rqst.getAcnt(), (String)ResManager.loadKDString((String)"\u865a\u8d26\u6237\u4f59\u989d\u67e5\u8be2", (String)"VirtualTodayBalanceParser_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (BankResponse)response, (String)"0");
        Element xDataBody = root.getChild("xDataBody");
        Element List2 = JDomUtils.getChildElement((Element)xDataBody, (String)"List");
        List Map2 = List2.getChildren("Map");
        EBBankBalanceResponse balanceResponse = new EBBankBalanceResponse();
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        if (!Map2.isEmpty()) {
            balanceInfos = new ArrayList(Map2.size());
        }
        for (Element item : Map2) {
            String VirtualAcNo = item.getChildText("VirtualAcNo");
            String VirtualAcName = item.getChildText("VirtualAcName");
            String Currency = item.getChildText("Currency");
            String SelfBalance = item.getChildText("SelfBalance");
            BalanceInfo balanceInfo = new BalanceInfo();
            BalanceUtil.setAvailableBalance((BalanceInfo)balanceInfo, (String)SelfBalance);
            BankAcnt acnt = new BankAcnt();
            acnt.setAccNo(VirtualAcNo);
            acnt.setAccName(VirtualAcName);
            BalanceUtil.setBankAcnt((BalanceInfo)balanceInfo, (BankAcnt)acnt);
            BalanceUtil.setBalanceDateTime((BalanceInfo)balanceInfo, (LocalDateTime)LocalDateTime.now());
            BalanceUtil.setCurrentBalance((BalanceInfo)balanceInfo, (String)SelfBalance);
            BalanceUtil.setBankCurrency((BalanceInfo)balanceInfo, (String)Currency);
            balanceInfos.add(balanceInfo);
        }
        balanceResponse.setBalances(balanceInfos);
        return balanceResponse;
    }
}

