/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.individual;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.AcntHelp;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.PayPacker;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.PayParser;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.individual.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class PaymentImpl
extends AbstractPayImpl {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri(Packer.getURL());
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "Xfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8f6c\u8d26\u4ea4\u6613(Xfer)", (String)"PaymentImpl_4", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        String subBizType = paymentInfo.getSubBizType();
        if ("pay_for_salary".equalsIgnoreCase(subBizType)) {
            paymentInfo.setIndividual(Boolean.valueOf(true));
            AcntHelp.checkAccCity(paymentInfo);
            return !paymentInfo.is2SameBank();
        }
        if ("pay".equalsIgnoreCase(subBizType) && UseConvertor.isSalary((PaymentInfo)paymentInfo)) {
            paymentInfo.setIndividual(Boolean.valueOf(true));
            return !paymentInfo.is2SameBank();
        }
        if (!(!"pay".equalsIgnoreCase(paymentInfo.getSubBizType()) || UseConvertor.isSalary((PaymentInfo)paymentInfo) || UseConvertor.isTransfer((PaymentInfo)paymentInfo) || BankBusinessConfig.isVirtualAccount(paymentInfo.getAccNo()) || !paymentInfo.is2Individual() || BankBusinessConfig.isUseOnlinePay() || paymentInfo.is2SameBank() || BankBusinessConfig.isDiffBankIndividual2Batch())) {
            paymentInfo.setPackageKey("accNo=" + paymentInfo.getAccNo());
            return true;
        }
        return false;
    }

    public String pack(BankPayRequest request) {
        return PayPacker.packPay(request.getPaymentInfoAsArray());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return PayParser.parsePay(request.getPaymentInfoAsArray(), responseStr);
    }
}

