/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.precheck;

import kd.ebg.aqap.banks.cmbc.dc.services.ExplanationUtil;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salary.PayPacker;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salary.PayParser;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.batch.salary.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchCostReimbPaymentImpl
extends AbstractPayImpl {
    public int getBatchSize() {
        return 5000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        boolean isReimed;
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        PaymentInfo info = paymentInfos[0];
        Element root = Packer.createMessageWithHead("BatchTransferCostReimb");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)xdataBody, (String)"insId", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)xdataBody, (String)"payerAcNo", (String)paymentInfos[0].getAccNo());
        String type = "1";
        String usage = "4111";
        boolean bl = isReimed = info.getUseCN().contains(PropertiesConstants.getValue((String)"CLAIM_PAYMENT")) || !StringUtils.isEmpty((String)info.getExplanation()) && info.getExplanation().contains(PropertiesConstants.getValue((String)"CLAIM_PAYMENT"));
        if (isReimed) {
            type = "2";
            usage = ExplanationUtil.convertExplToBank(info.getExplanation(), info.getAmount());
        }
        JDomUtils.addChild((Element)xdataBody, (String)"payType", (String)type);
        JDomUtils.addChild((Element)xdataBody, (String)"totalRow", (String)("" + paymentInfos.length));
        JDomUtils.addChild((Element)xdataBody, (String)"totalAmt", (String)bankPayRequest.getTotalAmount().setScale(2, 4).toString());
        JDomUtils.addChild((Element)xdataBody, (String)"fileContent", (String)PayPacker.getFileContent(paymentInfos));
        JDomUtils.addChild((Element)xdataBody, (String)"Usage", (String)usage);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        return PayParser.parsePay(bankPayRequest.getPaymentInfoAsArray(), responseStr);
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "BatchTransferCostReimb";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(Packer.getURL());
    }
}

