/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.dc.service.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.gdb.dc.util.Packer;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        if (BankBusinessConfig.isFixedAcnt(request.getAcnt().getAccNo())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5b9a\u671f\u6237\u4e0d\u652f\u6301\u67e5\u8be2\u5386\u53f2\u4f59\u989d\u3002", (String)"HisBalanceImpl_0", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]));
        }
        Element root = Packer.createRootNode();
        Element message = Packer.createMessageNode(root, "0028", Packer.getSeqNo());
        Element body = JDomUtils.addChild((Element)message, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"account", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        EBBankBalanceResponse bankHisBalanceResponse = new EBBankBalanceResponse();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element message = JDomUtils.getChildElement((Element)root, (String)"Message");
        Element commHead = JDomUtils.getChildElement((Element)message, (String)"commHead");
        String retCode = JDomUtils.getChildText((Element)commHead, (String)"retCode");
        Element body = JDomUtils.getChildElement((Element)message, (String)"Body");
        ArrayList<BalanceInfo> hisBalanceList = new ArrayList<BalanceInfo>(16);
        if ("000".equalsIgnoreCase(retCode)) {
            if (null == body) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de body \u4e3a\u7a7a\u3002", (String)"HisBalanceImpl_1", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]));
            }
            String account = JDomUtils.getChildText((Element)body, (String)"account");
            String totalNum = JDomUtils.getChildText((Element)body, (String)"totalNum");
            Element records = JDomUtils.getChildElement((Element)body, (String)"records");
            if (records == null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u6ca1\u6709\u8fd4\u56de\u4f59\u989d\u8bb0\u5f55\u3002", (String)"HisBalanceImpl_5", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]));
            }
            List recordList = records.getChildren("record");
            if (recordList != null && recordList.size() > 0) {
                for (Element record : recordList) {
                    String queryDate = JDomUtils.getChildText((Element)record, (String)"queryDate");
                    String avaiBalance = JDomUtils.getChildText((Element)record, (String)"avaiBalance");
                    String reserve1 = JDomUtils.getChildText((Element)record, (String)"reserve1");
                    String reserve2 = JDomUtils.getChildText((Element)record, (String)"reserve2");
                    String reserve3 = JDomUtils.getChildText((Element)record, (String)"reserve3");
                    String reserve4 = JDomUtils.getChildText((Element)record, (String)"reserve4");
                    String reserve5 = JDomUtils.getChildText((Element)record, (String)"reserve5");
                    BalanceInfo hisBalance = new BalanceInfo();
                    hisBalance.setBankAcnt(request.getAcnt());
                    this.setBankAcnt(hisBalance, request.getBankAcntList(), account);
                    this.setBalanceDateTime(hisBalance, queryDate + "235959", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                    this.setCurrentBalance(hisBalance, avaiBalance);
                    hisBalance.setBankCurrency(request.getBankCurrency());
                    hisBalanceList.add(hisBalance);
                }
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)retCode, (String)""));
        }
        bankHisBalanceResponse.setBalances(hisBalanceList);
        return bankHisBalanceResponse;
    }

    public LocalDate limitDate() {
        return LocalDate.now().minusDays(31L);
    }

    public String getDeveloper() {
        return "zhangyp";
    }

    public String getBizCode() {
        return "0028";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5386\u53f2\u4f59\u989d", (String)"HisBalanceImpl_7", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean isForm() {
        String exchangeProtocol = RequestContextUtils.getExchangeProtocol();
        return "http".equalsIgnoreCase(exchangeProtocol);
    }

    public String getFormKey() {
        return "cgb_data";
    }
}

