/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.dc.service.payment.company;

import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.dc.util.Packer;
import kd.ebg.aqap.banks.gdb.dc.util.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(CompanyQueryPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "1004";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u6b65\u4ed8\u6b3e", (String)"CompanyQueryPayImpl_0", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        String TEST_DATE = RequestContextUtils.getBankParameterValue((String)"TEST_DATE");
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = Packer.createRootNode();
        Element message = Packer.createMessageNode(root, "1004", Packer.getSeqNo());
        Element body = JDomUtils.addChild((Element)message, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"origEntseqno", (String)paymentInfo.getBankDetailSeqId());
        if (StringUtils.isEmpty((String)TEST_DATE)) {
            JDomUtils.addChild((Element)body, (String)"origEntdate", (String)paymentInfo.getSubmitSuccessTime().toLocalDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        } else {
            JDomUtils.addChild((Element)body, (String)"origEntdate", (String)TEST_DATE);
        }
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parserHeadXml(root);
        if (!"000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"CompanyQueryPayImpl_1", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        Element message = JDomUtils.getChildElement((Element)root, (String)"Message");
        Element body = JDomUtils.getChildElement((Element)message, (String)"Body");
        if (null != body) {
            String hostStatus = JDomUtils.getChildText((Element)body, (String)"hostStatus");
            String ERRORREASON = JDomUtils.getChildText((Element)body, (String)"ERRORREASON");
            if (paymentInfo.is2SameBank()) {
                if ("6".equalsIgnoreCase(hostStatus)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyQueryPayImpl_2", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)hostStatus, (String)ERRORREASON);
                } else if ("7".equalsIgnoreCase(hostStatus)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyQueryPayImpl_3", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)hostStatus, (String)ERRORREASON);
                } else if ("E".equalsIgnoreCase(hostStatus)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyQueryPayImpl_4", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)hostStatus, (String)ERRORREASON);
                } else {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyQueryPayImpl_5", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)hostStatus, (String)ERRORREASON);
                }
            } else if ("B".equalsIgnoreCase(hostStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyQueryPayImpl_2", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)hostStatus, (String)ERRORREASON);
            } else if ("C".equalsIgnoreCase(hostStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyQueryPayImpl_3", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)hostStatus, (String)ERRORREASON);
            } else if ("A".equalsIgnoreCase(hostStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyQueryPayImpl_4", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)hostStatus, (String)ERRORREASON);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyQueryPayImpl_5", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (String)hostStatus, (String)ERRORREASON);
            }
        } else {
            log.info("\u94f6\u884c\u8fd4\u56de body \u8282\u70b9\u4e3a\u7a7a");
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean isForm() {
        String exchangeProtocol = RequestContextUtils.getExchangeProtocol();
        return "http".equalsIgnoreCase(exchangeProtocol);
    }

    public String getFormKey() {
        return "cgb_data";
    }
}

