/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.glb.dc.services.payment.batch;

import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBPacker;
import kd.ebg.aqap.banks.glb.dc.services.utils.GLBStringUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QryTransferBatchImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(QryTransferBatchImpl.class);

    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element ebank_root = new Element("ebank");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData(this.getBizCode()));
        String submitTime = paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        logger.info("submitTime2:" + submitTime);
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"searchPayAccount", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)submitTime);
        JDomUtils.addChild((Element)body, (String)"endDate", (String)submitTime);
        JDomUtils.addChild((Element)body, (String)"batchNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"orderFlowNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"turnPageBeginPos", (String)"0");
        JDomUtils.addChild((Element)body, (String)"turnPageShowNum", (String)"5000");
        JDomUtils.addChild((Element)body, (String)"orderState", (String)"");
        JDomUtils.addChild((Element)body, (String)"businessCode", (String)"020104");
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String headtosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("head"), (String)RequestContextUtils.getCharset());
        String bodytosign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("body"), (String)RequestContextUtils.getCharset());
        String reqstMsg = headtosign + bodytosign;
        String sign = GLBPacker.sign(reqstMsg);
        JDomUtils.addChild((Element)ebank_root, (String)"sign", (String)sign);
        sign = JDomUtils.element2StringPlain((Element)ebank_root.getChild("sign"), (String)RequestContextUtils.getCharset());
        String requestXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><ebank>" + GLBStringUtils.replaceBlank(reqstMsg) + GLBStringUtils.replaceBlank(sign) + "</ebank>";
        logger.info("requestMessage:" + requestXml);
        return requestXml;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element ebenk = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        logger.info("\u540c\u6b65\u8fd4\u56de\u62a5\u6587rspStr\uff1a" + s);
        Element head = ebenk.getChild("head");
        if (!"000000".equals(head.getChildTextTrim("retCode"))) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5386\u53f2\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"QryTransferBatchImpl_4", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]), head.getChildText("retMessage"));
            logger.info("\u8fd4\u56de\u4fe1\u606f\uff1a" + s);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = ebenk.getChild("body");
        Element list = JDomUtils.getChildElement((Element)body, (String)"list");
        List Elements = list.getChildren("row");
        Map<String, String> result = QryTransferBatchImpl.getResultFromBank(Elements);
        for (PaymentInfo paymentInfo : paymentInfos) {
            logger.info("bankDetailSeqId:" + paymentInfo.getBankDetailSeqId());
            String orderFlowNo = paymentInfo.getBankDetailSeqId();
            String resultInfo = result.get(orderFlowNo);
            logger.info("resultInfo:" + resultInfo);
            if (StringUtils.isEmpty((String)resultInfo)) continue;
            String[] resultInfos = resultInfo.split("@_");
            String status = resultInfos[0];
            String errCode = "";
            String errMessage = "";
            if (resultInfos.length == 3) {
                errCode = resultInfos[1];
                errMessage = resultInfos[2];
            }
            logger.info("status:" + status);
            logger.info("is equals:" + "90".equalsIgnoreCase(status));
            if ("90".equalsIgnoreCase(status)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QryTransferBatchImpl_1", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QryTransferBatchImpl_1", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]));
                continue;
            }
            if ("99".equalsIgnoreCase(status)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QryTransferBatchImpl_2", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]), (String)errCode, (String)errMessage);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QryTransferBatchImpl_3", (String)"ebg-aqap-banks-glb-dc", (Object[])new Object[0]), (String)errCode, (String)errMessage);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public static Map<String, String> getResultFromBank(List<Element> elements) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        for (Element element : elements) {
            String orderFlowNo = JDomUtils.getChildTextTrim((Element)element, (String)"orderFlowNo");
            String orderState = JDomUtils.getChildTextTrim((Element)element, (String)"orderState");
            String errorCode = JDomUtils.getChildTextTrim((Element)element, (String)"errorCode");
            String errorMessage = JDomUtils.getChildTextTrim((Element)element, (String)"errorMessage");
            String resultInfo = orderState + "@_" + errorCode + "@_" + errorMessage;
            map.put(orderFlowNo, resultInfo);
        }
        return map;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE020112";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/corporbank/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
    }
}

