/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gxnx.cmp.services.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gxnx.cmp.services.utils.Packer;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/corporbank/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        String balanceReq = Packer.packBalance(bankBalanceRequest);
        return "CBE002|#" + balanceReq;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        int index = rspStr.indexOf("#");
        String[] split = rspStr.substring(0, index).split("\\|");
        String responseCode = split[0];
        if (!"0000".equalsIgnoreCase(responseCode)) {
            String responseMsg = "";
            if (split.length > 1) {
                responseMsg = split[1];
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s \u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]), responseCode, responseMsg));
        }
        String body = rspStr.substring(index + 1);
        body = Packer.decodeResponse(body);
        Element root = JDomUtils.string2Root((String)body, (String)RequestContextUtils.getCharset());
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        String balance = JDomUtils.getChildText((Element)opResult, (String)"balance");
        String balanceAvailable = JDomUtils.getChildText((Element)opResult, (String)"balanceAvailable");
        String currencyTyp = JDomUtils.getChildText((Element)opResult, (String)"currencyTyp");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(10);
        BalanceInfo balanceInfo = new BalanceInfo();
        if (!bankBalanceRequest.getBankCurrency().equalsIgnoreCase(currencyTyp)) {
            balanceInfo.setError(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5e01\u522b\u4e0e\u67e5\u8be2\u4e0a\u9001\u5e01\u522b\u4e0d\u4e00\u81f4\u3002", (String)"BalanceImpl_5", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]));
        } else {
            balanceInfo.setBankCurrency(currencyTyp);
            if (StringUtils.isEmpty((String)balance)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"BalanceImpl_4", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]));
            }
            balanceInfo.setCurrentBalance(new BigDecimal(balance));
            if (!StringUtils.isEmpty((String)balance)) {
                balanceInfo.setAvailableBalance(new BigDecimal(balanceAvailable));
            }
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
        }
        balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
        balanceInfos.add(balanceInfo);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u516c\u8d26\u53f7\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]);
    }
}

