/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.opa.service.balance;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjb.opa.service.utils.CommonPacker;
import kd.ebg.aqap.banks.bjb.opa.service.utils.CommonParser;
import kd.ebg.aqap.banks.bjb.opa.service.utils.CommonUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        CommonUtils.checkSingleCurrency(request.getCurrency());
        JSONObject requestJson = CommonPacker.createData(this.getBizCode());
        requestJson.put("accountNo", (Object)((BankAcnt)request.getBankAcntList().get(0)).getAccNo());
        String xmlRequest = CommonPacker.createRequest("balance", requestJson.toJSONString());
        return xmlRequest;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String res) {
        res = CommonParser.parseResponse(res);
        CommonUtils.checkSuccess(res);
        JSONObject response = JSONObject.parseObject((String)res);
        String curBal = response.getString("curBal");
        curBal = curBal.replaceAll(",", "");
        BalanceInfo balanceInfo = new BalanceInfo();
        this.setBankAcnt(balanceInfo, (BankAcnt)bankBalanceRequest.getBankAcntList().get(0));
        this.setCurrentBalance(balanceInfo, curBal);
        balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
        return new EBBankBalanceResponse(Collections.singletonList(balanceInfo));
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return "CebankQueryBalanceOp";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-bjb-opa", (Object[])new Object[0]);
    }
}

