/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.opa.service.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjb.opa.service.utils.CommonPacker;
import kd.ebg.aqap.banks.bjb.opa.service.utils.CommonParser;
import kd.ebg.aqap.banks.bjb.opa.service.utils.CommonUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class TodayDetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger logger = EBGLogger.getInstance().getLogger(TodayDetailImpl.class);

    public String pack(BankDetailRequest request) {
        CommonUtils.checkSingleCurrency(request.getBankCurrency());
        JSONObject requestJson = CommonPacker.createData(this.getBizCode());
        requestJson.put("acctNo", (Object)request.getAcnt().getAccNo());
        requestJson.put("startDate", (Object)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        requestJson.put("endDate", (Object)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        requestJson.put("tranDirection", (Object)"A");
        if ("0".equals(this.getCurrentPage())) {
            this.setCurrentPage("1");
        }
        requestJson.put("startPageNo", (Object)this.getCurrentPage());
        requestJson.put("pageSize", (Object)"100");
        String xmlRequest = CommonPacker.createRequest("detail", requestJson.toJSONString());
        return xmlRequest;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String res) {
        this.setLastPage(true);
        res = CommonParser.parseResponse(res);
        CommonUtils.checkSuccess(res);
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        JSONObject response = JSONObject.parseObject((String)res);
        JSONArray opResultSet = response.getJSONArray("opResultSet");
        if (opResultSet.size() == 0) {
            return new EBBankDetailResponse(detailList);
        }
        String totalNum = response.getString("totalNum");
        int currentPage = Integer.parseInt(this.getCurrentPage());
        if (StringUtils.isNotEmpty((String)totalNum) && Integer.parseInt(totalNum) > currentPage * 100) {
            this.setCurrentPage(currentPage + 1);
            this.setLastPage(false);
        }
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < opResultSet.size(); ++i) {
            try {
                JSONObject opResult = opResultSet.getJSONObject(i);
                DetailInfo detailInfo = new DetailInfo();
                String acctNo = opResult.getString("acctNo");
                String tranDate = opResult.getString("tranDate");
                String tranTime = opResult.getString("tranTime");
                String tranSummary = opResult.getString("tranSummary");
                String tranDirection = opResult.getString("tranDirection");
                String balanceCurrent = opResult.getString("balanceCurrent");
                String tranAmt = opResult.getString("tranAmt");
                String tranAcctName = opResult.getString("tranAcctName");
                String tranAcctNo = opResult.getString("tranAcctNo");
                String tranBankName = opResult.getString("tranBankName");
                String tranCoreSeqNo = opResult.getString(" tranCoreSeqNo");
                detailInfo.setAccNo(acctNo);
                detailInfo.setAccName(bankDetailRequest.getAcnt().getAccName());
                detailInfo.setCurrency(bankDetailRequest.getBankCurrency());
                detailInfo.setTransDate(LocalDateUtil.parserDate((String)tranDate));
                detailInfo.setTransTime(LocalDateUtil.parseDateTime((String)(tranDate + tranTime)));
                detailInfo.setOppAccName(tranAcctName);
                detailInfo.setOppAccNo(tranAcctNo);
                detailInfo.setOppBankName(tranBankName);
                detailInfo.setBankDetailNo(tranCoreSeqNo);
                if (StringUtils.isNotEmpty((String)balanceCurrent)) {
                    balanceCurrent = balanceCurrent.replaceAll(",", "");
                    detailInfo.setBalance(new BigDecimal(balanceCurrent));
                }
                detailInfo.setExplanation(tranSummary);
                if (StringUtils.isEmpty((String)tranAmt)) {
                    throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getDetailAmountEmptyErrorTips());
                }
                tranAmt = tranAmt.replaceAll(",", "");
                if ("D".equals(tranDirection)) {
                    detailInfo.setDebitAmount(new BigDecimal(tranAmt));
                    detailInfo.setCreditAmount(new BigDecimal("0.0"));
                } else if ("C".equals(tranDirection)) {
                    detailInfo.setCreditAmount(new BigDecimal(tranAmt));
                    detailInfo.setDebitAmount(new BigDecimal("0.0"));
                } else {
                    throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getDetailCDFlagErrorTips((String)tranDirection));
                }
                detailInfo.setJsonMap(opResult.toJSONString());
                String transDateStr = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate());
                String jsonStr = opResult.toJSONString();
                String receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getAcnt().getAccNo(), transDateStr, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detailInfo.setReceiptNo(receiptNo);
                detailList.add(detailInfo);
                continue;
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return "CebankDetailQueryByPageOp";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"TodayDetailImpl_0", (String)"ebg-aqap-banks-bjb-opa", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }
}

