/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.uob.dc.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.uob.dc.utils.Cert;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class UOBUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(UOBUtil.class);

    public static Cert getKeyFromDB(String propertyID) {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(propertyID, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            logger.info(propertyID);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u5148\u5230\u8fde\u63a5\u901a\u9053\u914d\u7f6e\u9875\u9762\u914d\u7f6e\u3002", (String)"UOBUtil_0", (String)"ebg-aqap-banks-uob-dc", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = UOBUtil.getCipherInfo(certInfo.getFileContent());
        byte[] bytes = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return new Cert(bytes, (StringUtils.isEmpty((String)certInfo.getCertPassword()) ? "" : certInfo.getCertPassword()).toCharArray());
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(org.apache.commons.codec.binary.Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }

    public static String generateJWT(String data) {
        String signature;
        JSONObject header = new JSONObject();
        header.put("alg", (Object)"RS256");
        header.put("typ", (Object)"JWT");
        String Header = org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])header.toJSONString().getBytes(StandardCharsets.UTF_8));
        String Payload = org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])data.getBytes(StandardCharsets.UTF_8));
        Cert cert = UOBUtil.getKeyFromDB("signkey");
        String alias = RequestContextUtils.getBankParameterValue((String)"sign_key_alias");
        try (ByteArrayInputStream is = new ByteArrayInputStream(cert.getStream());){
            Key key;
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(is, cert.getPwd());
            if (StringUtils.isEmpty((String)alias)) {
                ArrayList<String> aliasesList = Collections.list(keyStore.aliases());
                alias = aliasesList.get(0);
            }
            if (!((key = keyStore.getKey(alias, cert.getPwd())) instanceof PrivateKey)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u79c1\u94a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u7684\u522b\u540d\u662f\u5426\u6709\u8bef\u3002", (String)"", (String)"ebg-aqap-banks-uob-dc", (Object[])new Object[0]));
            }
            Signature s = Signature.getInstance("SHA256withRSA");
            s.initSign((PrivateKey)key);
            String beSigned = Header + "." + Payload;
            s.update(beSigned.getBytes(StandardCharsets.UTF_8));
            signature = org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])s.sign());
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            logger.info("\u7b7e\u540d\u5f02\u5e38{}", new Object[]{e.getClass().getName(), e});
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        catch (Exception e) {
            logger.info("\u7b7e\u540d\u5176\u4ed6\u5f02\u5e38{}", (Object)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return String.join((CharSequence)".", Lists.newArrayList((Object[])new String[]{Header, Payload, signature}));
    }

    public static void setReqHeader(ConnectionFactory factory, String method, String authorization) {
        String appID = RequestContextUtils.getBankParameterValue((String)"appid");
        String apiKey = RequestContextUtils.getBankParameterValue((String)"apikey");
        String clientID = RequestContextUtils.getBankParameterValue((String)"clientid");
        factory.setHttpHeader("Request Method", method);
        factory.setHttpHeader("Application-ID", appID);
        factory.setHttpHeader("API-Key", apiKey);
        factory.setHttpHeader("Client-ID", clientID);
        factory.setHttpHeader("Authorization", authorization);
        factory.setHttpHeader("Country", "CN");
        factory.setHttpHeader("Content-Type", "application/json");
    }

    public static String request(HttpRequestBase request, String msg) throws IOException {
        CloseableHttpClient client = UOBUtil.getClient();
        String appID = RequestContextUtils.getBankParameterValue((String)"appid");
        String apiKey = RequestContextUtils.getBankParameterValue((String)"apikey");
        String clientID = RequestContextUtils.getBankParameterValue((String)"clientid");
        request.setHeader("Application-ID", appID);
        request.setHeader("API-Key", apiKey);
        request.setHeader("Client-ID", clientID);
        request.setHeader("Authorization", msg);
        request.setHeader("Country", "CN");
        request.setHeader("Content-Type", "application/json");
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String resp = EntityUtils.toString((HttpEntity)entity);
        logger.info("\u54cd\u5e94\u7801{} \u54cd\u5e94\u7684\u62a5\u6587->{}", new Object[]{statusCode, resp});
        JSONObject root = JSONObject.parseObject((String)resp);
        if (!StringUtils.isEmpty((String)root.getString("code"))) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4e1a\u52a1\u5f02\u5e38\uff0c\u54cd\u5e94\u4fe1\u606f\uff1a%s\u3002", (String)"", (String)"ebg-aqap-banks-uob-dc", (Object[])new Object[0]), root.getString("description")));
        }
        return resp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CloseableHttpClient getClient() {
        Cert cert = UOBUtil.getKeyFromDB("sslkey");
        try (ByteArrayInputStream is = new ByteArrayInputStream(cert.getStream());){
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(is, cert.getPwd());
            SSLContext sslcontext = SSLContextBuilder.create().loadKeyMaterial(keyStore, cert.getPwd()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1", "TLSv1.2"}, null, (HostnameVerifier)new DefaultHostnameVerifier());
            int timeOut = Integer.parseInt(RequestContextUtils.getBankParameterValue((String)"timeout"));
            RequestConfig config = RequestConfig.custom().setConnectTimeout(2000).setSocketTimeout(timeOut * 60 * 1000).build();
            CloseableHttpClient closeableHttpClient = HttpClients.custom().setDefaultRequestConfig(config).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            return closeableHttpClient;
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6HttpClient\u5f02\u5e38 {}", (Object)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static String url(String uri) {
        String IP = RequestContextUtils.getBankParameterValue((String)"ip");
        if (IP.startsWith("https://")) {
            IP = IP.substring("https://".length());
        }
        return "https://" + IP + uri;
    }
}

