/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailParser {
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailParser.class);

    public List<DetailInfo> parseHisDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        return this.parseDetail(rqst, rspStr);
    }

    public List<DetailInfo> parseTodayDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        return this.parseDetail(rqst, rspStr);
    }

    public List<DetailInfo> parseDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        if (BankBusinessConfig.isCaiZiAcnt(rqst.getAcnt().getAccNo())) {
            return this.parseCaiZiDetail(rqst, rspStr);
        }
        return this.parseNormalDetail(rqst, rspStr);
    }

    public static String preTreatXML(String responseStr) {
        StringBuilder sb = new StringBuilder();
        String xml = "";
        int totalLen = responseStr.length();
        int startIndex = 0;
        int endIndex = 0;
        int lastIndex = 0;
        int offset = 0;
        while (startIndex > -1) {
            xml = responseStr.substring(lastIndex, totalLen);
            startIndex = xml.indexOf("<DET>");
            endIndex = xml.indexOf("</DET>");
            if (startIndex > 0 && endIndex > 0) {
                sb.append(responseStr.substring(offset, startIndex += offset));
                String tempString = responseStr.substring(startIndex, endIndex += offset).substring("<DET>".length());
                tempString = tempString.replaceAll("<", "(").replaceAll(">", ")");
                sb.append("<DET>").append(tempString).append("</DET>");
                offset = lastIndex = endIndex + "</DET>".length();
                continue;
            }
            sb.append(xml);
        }
        return sb.toString();
    }

    public List<DetailInfo> parseNormalDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        rspStr = DetailParser.preTreatXML(rspStr);
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>(16);
        String rspCode = response.getResponseCode();
        if ("000000".equalsIgnoreCase(rspCode)) {
            String err_level;
            Element txInfo = root.getChild("TX_INFO");
            String accNo = root.getChildText("ACCNO1");
            if (accNo == null) {
                accNo = rqst.getAcnt().getAccNo();
            }
            if (!StringUtils.isEmpty((String)(err_level = root.getChildText("ERR_LEVEL")))) {
                String err_msg = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u6d88\u606f:%s\u3002", (String)"DetailParser_3", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), root.getChildText("ERR_MSG"));
                this.log.error(err_msg);
                throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspCode, (String)root.getChildText("ERR_MSG")));
            }
            Element DETAILLIST = txInfo.getChild("DETAILLIST");
            List detail = DETAILLIST.getChildren("DETAILINFO");
            if (detail == null || detail.size() == 0) {
                this.log.info("\u8fd4\u56deDETAIL\u8282\u70b9: null == detail || 0 == detail.size()");
                return new ArrayList<DetailInfo>();
            }
            String currencyType = txInfo.getChildTextTrim("CURR_COD");
            if (StringUtils.isEmpty((String)currencyType)) {
                this.log.error(ShowTipUtil.getDetailCurrencyEmptyTips());
                return new ArrayList<DetailInfo>();
            }
            String totalPage = txInfo.getChildTextTrim("TOTAL_PAGE");
            if ("0".equalsIgnoreCase(totalPage)) {
                return list;
            }
            HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
            for (Element detailElement : detail) {
                String oppAccNo = detailElement.getChildTextTrim("ACCNO2");
                String oppAccName = detailElement.getChildTextTrim("ACC_NAME1");
                DetailInfo detailInfo = new DetailInfo();
                detailInfo.setOppAccNo(oppAccNo);
                detailInfo.setOppAccName(oppAccName);
                detailInfo.setCurrency(currencyType);
                String amtStr = detailElement.getChildText("AMT");
                String dORcFlag = detailElement.getChildText("FLAG1");
                if (StringUtils.isEmpty((String)amtStr)) {
                    this.log.error(ShowTipUtil.getDetailAmountEmptyErrorTips());
                    continue;
                }
                if ("0".equalsIgnoreCase(dORcFlag)) {
                    detailInfo.setDebitAmount(new BigDecimal(amtStr));
                    detailInfo.setCreditAmount(new BigDecimal("0"));
                } else if ("1".equalsIgnoreCase(dORcFlag)) {
                    detailInfo.setCreditAmount(new BigDecimal(amtStr));
                    detailInfo.setDebitAmount(new BigDecimal("0"));
                } else {
                    this.log.error(ShowTipUtil.getDetailCDFlagErrorTips((String)dORcFlag));
                    continue;
                }
                String balStr = detailElement.getChildTextTrim("AMT1");
                if (!StringUtils.isEmpty((String)balStr)) {
                    detailInfo.setBalance(new BigDecimal(balStr));
                }
                String det = detailElement.getChildTextTrim("DET");
                String message = detailElement.getChildTextTrim("MESSAGE");
                detailInfo.setExplanation(this.composeMsg(det, message));
                String transDate = detailElement.getChildTextTrim("TRANDATE");
                String realTransDate = detailElement.getChildTextTrim("REAL_TRANDATE");
                String rltvAccno = detailElement.getChildTextTrim("RLTV_ACCNO");
                detailInfo.setReversed1(rltvAccno);
                String detNo = JDomUtils.getChildText((Element)detailElement, (String)"DET_NO");
                String tranFlow = JDomUtils.getChildText((Element)detailElement, (String)"TRAN_FLOW");
                StringBuilder sb = new StringBuilder();
                sb.append(detNo).append("-").append(tranFlow);
                DetailSysFiled.set((DetailInfo)detailInfo, (String)"VouhNo", (String)sb.toString());
                DetailSysFiled.set((DetailInfo)detailInfo, (String)"bizRefNo", (String)sb.toString());
                detailInfo.setBankDetailNo(detNo);
                DetailSysFiled.set((DetailInfo)detailInfo, (String)"BankSeqNo", (String)detailElement.getChildTextTrim("TRAN_FLOW"));
                String oppBankName = JDomUtils.getChildText((Element)detailElement, (String)"CADBank_Nm");
                detailInfo.setOppBankName(oppBankName);
                String transTime = detailElement.getChildTextTrim("TRANTIME");
                String DATE_FORMAT = "yyyy/MM/dd";
                String TIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
                String completeDateTime = realTransDate;
                if (StringUtils.isEmpty((String)transDate)) {
                    detailInfo.setTransTime(LocalDateTime.now());
                } else {
                    completeDateTime = StringUtils.isEmpty((String)transTime) ? completeDateTime + " 00:00:00" : completeDateTime + " " + transTime;
                    try {
                        detailInfo.setTransDate(LocalDate.parse(transDate, DateTimeFormatter.ofPattern(DATE_FORMAT)));
                    }
                    catch (Exception e) {
                        this.log.error(ShowTipUtil.getDetailTransDateParseErrorTips((String)transDate));
                        continue;
                    }
                    try {
                        detailInfo.setTransTime(LocalDateTime.parse(completeDateTime, DateTimeFormatter.ofPattern(TIME_FORMAT)));
                    }
                    catch (Exception e) {
                        this.log.error(ShowTipUtil.getDetailTransDateParseErrorTips((String)completeDateTime));
                        continue;
                    }
                }
                String REM_CTX2 = detailElement.getChildTextTrim("DET");
                int index = REM_CTX2.indexOf("_KD_");
                if (index != -1) {
                    if (REM_CTX2.indexOf("NO@") != -1) {
                        String seqId = REM_CTX2.substring(index + "_KD_".length(), REM_CTX2.indexOf("NO@"));
                        DetailSysFiled.set((DetailInfo)detailInfo, (String)"KDRetFlag", (String)seqId);
                        detailInfo.setKdFlag(seqId);
                        detailInfo.setPayBankDetailSeqID(seqId);
                    } else {
                        DetailSysFiled.set((DetailInfo)detailInfo, (String)"KDRetFlag", (String)REM_CTX2.substring(0, index));
                        detailInfo.setPayBankDetailSeqID(REM_CTX2.substring(0, index));
                    }
                } else if (REM_CTX2.indexOf("-KD") != -1) {
                    String batchNo = REM_CTX2.substring(0, REM_CTX2.indexOf("-KD"));
                    DetailSysFiled.set((DetailInfo)detailInfo, (String)"batchNo", (String)batchNo);
                    DetailSysFiled.set((DetailInfo)detailInfo, (String)"KDRetFlag", (String)"KD");
                }
                String CRE_NO = detailElement.getChildTextTrim("CRE_NO");
                DetailSysFiled.set((DetailInfo)detailInfo, (String)"bizRefNo", (String)CRE_NO);
                if (PropertiesConstants.getValue((String)"DETAIL_KD_1").equals(message) || PropertiesConstants.getValue((String)"DETAIL_KD_2").equals(message)) {
                    DetailSysFiled.delete((DetailInfo)detailInfo, (String)"KDRetFlag");
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(detailElement);
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                jsonObject.put("serialNo", (Object)tranFlow);
                jsonObject.put("Amount", (Object)amtStr);
                detailInfo.setJsonMap(jsonObject.toJSONString());
                String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate()), detailInfo.getJsonMap());
                receiptNo = DetailParser.handTransUpReceiptNo(det, receiptNo);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detailInfo.setReceiptNo(receiptNo);
                list.add(detailInfo);
            }
            return list;
        }
        if (DetailParser.isNoDetilRspCode(rspCode)) {
            this.log.info("\u8fd4\u56de\u6ca1\u6709\u4ea4\u6613\u660e\u7ec6\u7684\u8fd4\u56de\u7801:" + rspCode);
            return new ArrayList<DetailInfo>();
        }
        throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspCode, (String)response.getResponseMessage()));
    }

    public static String handTransUpReceiptNo(String det, String receiptNo) {
        if (StringUtils.isNotEmpty((String)det) && det.contains(PropertiesConstants.getValue((String)"CASH_SWEEP"))) {
            return receiptNo + "_CASH_SWEEP";
        }
        return receiptNo;
    }

    public List<DetailInfo> parseCaiZiDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>(16);
        String rspCode = response.getResponseCode();
        if ("000000".equalsIgnoreCase(rspCode)) {
            String err_level;
            Element txInfo = root.getChild("TX_INFO");
            String accNo = root.getChildText("ACC_NO");
            if (accNo == null) {
                accNo = rqst.getAcnt().getAccNo();
            }
            if (!StringUtils.isEmpty((String)(err_level = root.getChildText("ERR_LEVEL")))) {
                String err_msg = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u6d88\u606f:%s\u3002", (String)"DetailParser_3", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), root.getChildText("ERR_MSG"));
                this.log.info(err_msg);
                throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspCode, (String)root.getChildText("ERR_MSG")));
            }
            Element DETAILLIST = txInfo.getChild("DETAILLIST");
            List detail = DETAILLIST.getChildren("DETAILINFO");
            if (detail == null || detail.size() == 0) {
                this.log.info("\u8fd4\u56deDETAIL\u8282\u70b9: null == detail || 0 == detail.size()");
                return new ArrayList<DetailInfo>();
            }
            String totalPage = txInfo.getChildTextTrim("TOTAL_PAGE");
            if ("0".equalsIgnoreCase(totalPage)) {
                return list;
            }
            HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
            for (Element detailElement : detail) {
                String bizRefNo;
                String oppAccNo = detailElement.getChildTextTrim("ACC_NO2");
                String oppAccName = detailElement.getChildTextTrim("ACC_NAME2");
                String currencyType = detailElement.getChildTextTrim("CURR_COD");
                if (StringUtils.isEmpty((String)currencyType)) {
                    this.log.error(ShowTipUtil.getDetailCurrencyEmptyTips());
                    continue;
                }
                String oppBankName = detailElement.getChildTextTrim("OPPO_OPAC_BRCH");
                DetailInfo detailInfo = new DetailInfo();
                detailInfo.setOppAccNo(oppAccNo);
                detailInfo.setOppAccName(oppAccName);
                detailInfo.setCurrency(currencyType);
                detailInfo.setOppBankName(oppBankName);
                String drAmtStr = detailElement.getChildTextTrim("DR_AMT");
                String crAmtStr = detailElement.getChildTextTrim("CR_AMT");
                if (StringUtils.isEmpty((String)drAmtStr) && StringUtils.isEmpty((String)crAmtStr)) {
                    this.log.error(ShowTipUtil.getDetailAmountEmptyErrorTips());
                    continue;
                }
                if (StringUtils.isNotEmpty((String)drAmtStr) && StringUtils.isNotEmpty((String)crAmtStr)) {
                    this.log.error(ShowTipUtil.getDetailAmountErrorTips());
                    continue;
                }
                detailInfo.setDebitAmount(new BigDecimal(drAmtStr));
                detailInfo.setCreditAmount(new BigDecimal(crAmtStr));
                String balStr = detailElement.getChildTextTrim("BAL_AMT");
                if (!StringUtils.isEmpty((String)balStr)) {
                    detailInfo.setBalance(new BigDecimal(balStr));
                }
                String det = detailElement.getChildTextTrim("DET");
                String message = detailElement.getChildTextTrim("MESSAGE");
                detailInfo.setExplanation(this.composeMsg(det, message));
                if (PropertiesConstants.getValue((String)"CASH_SWEEP").equalsIgnoreCase(message)) {
                    if (!"0.00".equalsIgnoreCase(crAmtStr)) {
                        detailInfo.setTransType("autotransup");
                    } else {
                        detailInfo.setTransType("autotransdown");
                    }
                }
                if (StringUtils.isEmpty((String)(bizRefNo = detailElement.getChildTextTrim("TX_LOG_NO")))) {
                    bizRefNo = "";
                }
                DetailSysFiled.set((DetailInfo)detailInfo, (String)"VouhNo", (String)bizRefNo);
                DetailSysFiled.set((DetailInfo)detailInfo, (String)"bizRefNo", (String)bizRefNo);
                String date = detailElement.getChildTextTrim("TRANDATE").replace("/", "");
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(detailElement);
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                jsonObject.put("serialNo", (Object)bizRefNo);
                if (detailInfo.getDebitAmount().compareTo(BigDecimal.ZERO) > 0) {
                    jsonObject.put("Amount", (Object)drAmtStr);
                }
                if (detailInfo.getCreditAmount().compareTo(BigDecimal.ZERO) > 0) {
                    jsonObject.put("Amount", (Object)crAmtStr);
                }
                detailInfo.setJsonMap(jsonObject.toJSONString());
                String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, date, detailInfo.getJsonMap());
                receiptNo = DetailParser.handTransUpReceiptNo(det, receiptNo);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detailInfo.setReceiptNo(receiptNo);
                String strDate = detailElement.getChildTextTrim("TRANDATE");
                String tx_time = detailElement.getChildTextTrim("TX_TM");
                String DATE_FORMAT = "yyyyMMdd";
                String DATE_FORMAT0 = "yyyyMMdd HHmmss";
                if (StringUtils.isEmpty((String)strDate)) {
                    detailInfo.setTransTime(LocalDateTime.now());
                } else {
                    try {
                        detailInfo.setTransDate(LocalDate.parse(strDate, DateTimeFormatter.ofPattern(DATE_FORMAT)));
                    }
                    catch (Exception e) {
                        this.log.error(ShowTipUtil.getDetailTransDateParseErrorTips((String)strDate));
                        continue;
                    }
                    if (StringUtils.isEmpty((String)tx_time)) {
                        tx_time = "000000";
                    }
                    String strDateTime = strDate + " " + tx_time;
                    try {
                        detailInfo.setTransTime(LocalDateTime.parse(strDateTime, DateTimeFormatter.ofPattern(DATE_FORMAT0)));
                    }
                    catch (Exception e) {
                        this.log.error(ShowTipUtil.getDetailTransDateParseErrorTips((String)strDateTime));
                        continue;
                    }
                }
                list.add(detailInfo);
            }
            return list;
        }
        if (DetailParser.isNoDetilRspCode(rspCode)) {
            this.log.info("\u8fd4\u56de\u6ca1\u6709\u4ea4\u6613\u660e\u7ec6\u7684\u8fd4\u56de\u7801:" + rspCode);
            return new ArrayList<DetailInfo>();
        }
        throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspCode, (String)response.getResponseMessage()));
    }

    public String composeMsg(String det, String message) {
        if (!StringUtils.isEmpty((String)det) && !StringUtils.isEmpty((String)message) && det.trim().equalsIgnoreCase(message.trim())) {
            return message;
        }
        StringBuilder buffer = new StringBuilder();
        if (!StringUtils.isEmpty((String)message)) {
            buffer.append(message);
        }
        if (!StringUtils.isEmpty((String)det)) {
            if (!StringUtils.isEmpty((String)message)) {
                buffer.append(',');
            }
            buffer.append(det);
        }
        String msg = buffer.toString();
        return msg;
    }

    public static boolean isNoDetilRspCode(String rspCode) {
        StringBuilder noDetailCode = new StringBuilder();
        noDetailCode.append("200001").append("_");
        noDetailCode.append("990000").append("_");
        noDetailCode.append("310211").append("_");
        noDetailCode.append("1261").append("_");
        noDetailCode.append("8440ZX310211").append("_");
        noDetailCode.append("8212ZXXX1261").append("_");
        noDetailCode.append("8230ZX200000").append("_");
        noDetailCode.append("8310ZX880002");
        return -1 != noDetailCode.toString().indexOf(rspCode);
    }
}

