/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.services.payment.CCBUseConvertor;
import kd.ebg.aqap.banks.ccb.dc.services.payment.income.PaymentImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    public void appendData(PaymentInfo paymentInfo) {
        this.getBusiImplInfo(paymentInfo);
        this.setPayRouteTrace(paymentInfo);
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        String subBizType = paymentInfo.getSubBizType();
        if (this.isIncome(paymentInfo)) {
            this.setImplClassName(paymentInfo, PaymentImpl.class.getName());
        } else if (this.isPay_for_salary(paymentInfo)) {
            if (this.isBatchSalaryPay(paymentInfo)) {
                this.setSubBizType4BatchSalary(paymentInfo);
            } else {
                this.setSubBizType4Salary(paymentInfo);
            }
        } else if (this.isPay_for_capital_allocation(paymentInfo)) {
            this.setSubBizType4CapitalAllocation(paymentInfo);
        } else if (this.isPay(paymentInfo)) {
            if (this.isSalaryUseCN(paymentInfo)) {
                if (this.isBatchSalaryPay(paymentInfo)) {
                    this.setSubBizType4BatchSalary(paymentInfo);
                } else {
                    this.setSubBizType4Salary(paymentInfo);
                }
            } else if (this.isTransferUseCN(paymentInfo)) {
                this.setSubBizType4CapitalAllocation(paymentInfo);
            } else if (paymentInfo.is2Individual()) {
                if (this.isIndividualToCompany()) {
                    this.checkExplanation(paymentInfo);
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.ccb.dc.services.payment.company.PaymentImpl.class.getName());
                } else if (this.isBatchIndividualPay()) {
                    CCBUseConvertor.transformUseCode4Individual(paymentInfo);
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.PaymentImpl.class.getName());
                } else {
                    CCBUseConvertor.transformUseCode4Individual(paymentInfo);
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.ccb.dc.services.payment.individual.PaymentImpl.class.getName());
                }
            } else {
                paymentInfo.setIndividual(Boolean.valueOf(false));
                this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.ccb.dc.services.payment.company.PaymentImpl.class.getName());
                this.checkExplanation(paymentInfo);
            }
        } else if (this.isPay_for_overseaPay(paymentInfo) && !paymentInfo.isDiffCurrency()) {
            this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.ccb.dc.services.payment.oversea.PaymentImpl.class.getName());
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8be5\u79cd\u4e1a\u52a1\u7c7b\u578b%s\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u7c7b\u578b\u662f\u5426\u6b63\u786e\u3002", (String)"PretreatmentImpl_5", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), subBizType));
        }
        return busiImplInfo;
    }

    public void setSubBizType4Salary(PaymentInfo paymentInfo) throws EBServiceException {
        paymentInfo.setIndividual(Boolean.valueOf(true));
        CCBUseConvertor.transformUseCode4Individual(paymentInfo);
        this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.ccb.dc.services.payment.individual.PaymentImpl.class.getName());
    }

    public void setSubBizType4BatchSalary(PaymentInfo paymentInfo) throws EBServiceException {
        paymentInfo.setIndividual(Boolean.valueOf(true));
        CCBUseConvertor.transformUseCode4Individual(paymentInfo);
        this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.PaymentImpl.class.getName());
    }

    public void setSubBizType4CapitalAllocation(PaymentInfo paymentInfo) throws EBServiceException {
        this.checkExplanation(paymentInfo);
        paymentInfo.setIndividual(Boolean.valueOf(false));
        this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.ccb.dc.services.payment.company.PaymentImpl.class.getName());
    }

    public void checkExplanation(PaymentInfo paymentInfo) throws EBServiceException {
        if (StringUtils.isEmpty((String)paymentInfo.getExplanation())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6458\u8981\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PretreatmentImpl_2", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        }
        if (paymentInfo.getExplanation().length() > 100) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6458\u8981\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26\u3002", (String)"PretreatmentImpl_3", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        }
    }

    public boolean isBatchSalaryPay(PaymentInfo paymentInfo) {
        if (this.isMerge(paymentInfo)) {
            return true;
        }
        return this.assertBusinessConfig("ccb_dc_isBatchIndividualPay", "true");
    }

    private boolean isIndividualToCompany() {
        return this.assertBusinessConfig("ccb_dc_isIndividualToCompany", "true");
    }

    private boolean isBatchIndividualPay() {
        return this.assertBusinessConfig("ccb_dc_isBatchIndividualPay", "true");
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        return null;
    }

    public String getDeveloper() {
        return "hpf";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"\u5efa\u884c\u76f4\u8054\u4ed8\u6b3e\u8def\u7531", (String)"PretreatmentImpl_4", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5efa\u884c\u76f4\u8054\u4ed8\u6b3e\u8def\u7531", (String)"PretreatmentImpl_4", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

