/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay;

import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.dc.services.payment.CCBUseConvertor;
import kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.PayPacker;
import kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.PayParser;
import kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.QueryPaymentImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 2000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "6W2102&6W2100";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"6W2102\u4ee3\u53d1\u6587\u4ef6\u4e0a\u4f20&6W2100\u4ea4\u6613\u529e\u7406\u4ee3\u53d1\u4ee3\u6263\u4e1a\u52a1", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        String subBizType = paymentInfo.getSubBizType();
        if ("pay_for_salary".equalsIgnoreCase(subBizType) && (this.isBatchSalaryPay(paymentInfo) || paymentInfo.is2Merge())) {
            CCBUseConvertor.transformUseCode4Individual(paymentInfo);
            paymentInfo.setIndividual(Boolean.valueOf(true));
            return true;
        }
        if ("pay".equalsIgnoreCase(subBizType)) {
            if (UseConvertor.isSalary((PaymentInfo)paymentInfo) && this.isBatchSalaryPay(paymentInfo)) {
                CCBUseConvertor.transformUseCode4Individual(paymentInfo);
                paymentInfo.setIndividual(Boolean.valueOf(true));
                return true;
            }
            if (!UseConvertor.isSalary((PaymentInfo)paymentInfo) && !UseConvertor.isTransfer((PaymentInfo)paymentInfo) && paymentInfo.is2Individual() && !BankBusinessConfig.isIndividualToCompany() && BankBusinessConfig.isBatchIndividualPay()) {
                CCBUseConvertor.transformUseCode4Individual(paymentInfo);
                return true;
            }
        }
        return false;
    }

    public boolean isBatchSalaryPay(PaymentInfo paymentInfo) {
        boolean chooseBatch = false;
        try {
            chooseBatch = BankBusinessConfig.isBatchIndividualPay();
        }
        catch (EBServiceException eBServiceException) {
            // empty catch block
        }
        return paymentInfo.is2Merge() || chooseBatch;
    }

    public String pack(BankPayRequest request) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return null;
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        String bankBatchSeqID = request.getBankBatchSeqID();
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        try {
            EBContext.getContext().setProcessFlag(PROCESS_PACK);
            PayPacker payPacker = new PayPacker();
            PayParser payParser = new PayParser();
            String rsqt6W2102 = payPacker.packPay(paymentInfos);
            if (StringUtils.isEmpty((String)rsqt6W2102)) {
                return new EBBankPayResponse(request.getPaymentInfos());
            }
            EBContext.getContext().setProcessFlag(PROCESS_CONNECTION);
            ConnectionFactory factory = this.getConnectionFactory();
            String rsp6W2102 = this.sendRsqtAndRecvRsp(factory, rsqt6W2102, bankBatchSeqID);
            EBContext.getContext().setProcessFlag(PROCESS_PARSE);
            payParser.parsePay(paymentInfos, rsp6W2102);
            try {
                if (paymentInfos[0].getStatus().intValue() != PaymentState.SUBMITTING.getId()) {
                    throw EBExceiptionUtil.serviceException((String)paymentInfos[0].getBankMsg());
                }
                EBContext.getContext().setProcessFlag(PROCESS_PACK);
                String rsqt6W2100 = payPacker.packPay6W2100(paymentInfos, rsp6W2102);
                EBContext.getContext().setProcessFlag(PROCESS_CONNECTION);
                String rsp6W2100 = this.sendRsqtAndRecvRsp(factory, rsqt6W2100, bankBatchSeqID);
                EBContext.getContext().setProcessFlag(PROCESS_PARSE);
                payParser.parsePay6W2100(paymentInfos, rsp6W2100);
            }
            catch (Throwable t) {
                RequestContextUtils.getRequestContext().setThrowableAfterSend(t);
            }
        }
        catch (Exception e) {
            EBContext.getContext().setExceptionMsg(e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public String sendRsqtAndRecvRsp(ConnectionFactory factory, String rsqt, String bankBatchSeqID) throws Exception {
        String rsp = "";
        try {
            IConnection conn = this.getConnection(factory);
            this.openConnection(conn);
            EBContext.getContext().setProcessFlag(PROCESS_CONNECTED);
            try (OutputStream os = this.getOutputStream(conn);){
                this.send(os, rsqt);
                try (InputStream is = this.getInputStream(conn);){
                    rsp = this.recv(is);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return rsp;
    }
}

