/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment.income;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class PayParser {
    private String[] SUCCESS = new String[]{"000000"};
    private static Map<String, String> failMap = new HashMap<String, String>(16);

    public void parsePay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (this.isMatched(response.getResponseCode(), this.SUCCESS)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"PayParser_5", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else if (this.isFailed(response)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PayParser_6", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5", (String)"PayParser_7", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
    }

    public boolean isFailed(BankResponse response) {
        String key = response.getResponseCode();
        String msg = response.getResponseMessage();
        if (StringUtils.isEmpty((String)msg)) {
            msg = "_NOT_SET_";
        }
        if (failMap.containsKey(key)) {
            String value = failMap.get(key);
            return value.contains(msg);
        }
        return false;
    }

    public boolean isMatched(String responseCode, String[] fields) {
        for (String field : fields) {
            if (!field.equalsIgnoreCase(responseCode)) continue;
            return true;
        }
        return false;
    }

    public static void put(String key, String value) {
        if (failMap.containsKey(key)) {
            String v = failMap.get(key);
            failMap.put(key, v + "|" + value);
        } else {
            failMap.put(key, value);
        }
    }

    static {
        PayParser.put("8310ZXMS1111", ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u8be5\u5361\u5df2\u9500\u6237\u3002", (String)"PayParser_8", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("8310ZXMS1111", ResManager.loadKDString((String)"\u8d26\u53f7\u4e0d\u7b26\u5bf9\u79c1\u89c4\u5219\u3002", (String)"PayParser_9", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("8310ZXMS1111", ResManager.loadKDString((String)"\u68c0\u9a8c\u6237\u540d\u9519", (String)"PayParser_10", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("8310ZXMS1111", ResManager.loadKDString((String)"\u5361\u6863\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002", (String)"PayParser_11", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("8310ZXMS1111", ResManager.loadKDString((String)"\u5e10\u53f7\u5e94\u4e3a\u6d3b\u671f\u5e10\u53f7\u3002", (String)"PayParser_12", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("8310ZXMS1111", ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u4f59\u989d\u4e0d\u8db3\u3002", (String)"PayParser_13", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("8310ZXMS1111", ResManager.loadKDString((String)"E3521\u4eba\u884c\u5173\u7f51\u65f6\u95f4\u5230\u3002", (String)"PayParser_14", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("8310ZXMS1111", ResManager.loadKDString((String)"E8322\u6b64\u5e10\u53f7\u4e0d\u901a\u5b58\u3002", (String)"PayParser_15", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("8310ZXMS1111", ResManager.loadKDString((String)"E8322\u6b64\u5e10\u53f7\u5168\u7701\u901a\u5b58", (String)"PayParser_16", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("8310ZXMS1111", ResManager.loadKDString((String)"E8322\u6b64\u5e10\u53f7\u5168\u5e02\u901a\u5b58\u3002", (String)"PayParser_17", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("8310ZXMS1111", ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u5e10\u6237\u63a7\u5236\u72b6\u6001\u4e0d\u5141\u8bb8\u5b58\u5165\u3002", (String)"PayParser_18", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("8310ZXMS1111", ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u540d\u79f0\u5b57\u6bb5\u6709\u975e\u6cd5\u5b57\u7b26\u3002", (String)"PayParser_19", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("8310ZXMS1111", ResManager.loadKDString((String)"\u7528\u9014\u5b57\u6bb5\u6709\u975e\u6cd5\u5b57\u7b26\u3002", (String)"PayParser_20", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("BSECS6205999", ResManager.loadKDString((String)"\u6536\u6b3e\u884c\u4fe1\u606f\u4e0d\u5168\u3002", (String)"PayParser_21", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("8310ZXXXXXMS", ResManager.loadKDString((String)"\u8f6c\u5165\u5e10\u6237\u6237\u540d\u4e0d\u7b26\u3002", (String)"PayParser_22", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("8310ZX880052", ResManager.loadKDString((String)"\u5b57\u6bb5\u8d85\u957f", (String)"PayParser_23", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013020100004", ResManager.loadKDString((String)"\u8d26\u6237\u5bc6\u7801\u4e0d\u6b63\u786e\u3002", (String)"PayParser_24", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013020100005", ResManager.loadKDString((String)"\u6237\u540d\u4e0d\u7b26", (String)"PayParser_25", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021101001", ResManager.loadKDString((String)"\u8f93\u5165\u7684\u4ea4\u6613\u8981\u7d20\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PayParser_26", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021101002", ResManager.loadKDString((String)"\u4ea4\u6613\u8f93\u5165\u8981\u7d20\u7684\u683c\u5f0f\u6216\u8f93\u5165\u8303\u56f4\u9519\u8bef\u3002", (String)"PayParser_27", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021101003", ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u4fe1\u606f\u4e0d\u7b26\u5408\u683c\u5f0f\u68c0\u67e5\u3002", (String)"PayParser_28", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021101004", ResManager.loadKDString((String)"\u60a8\u6240\u63d0\u4ea4\u7684\u8d26\u53f7\u5c1a\u672a\u7533\u8bf7\u7f51\u4e0a\u64cd\u4f5c\u529f\u80fd\uff0c\u4e0d\u80fd\u8fdb\u5165\u4ea4\u6613\u3002", (String)"PayParser_29", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021101007", ResManager.loadKDString((String)"\u8d26\u6237\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u4e0e\u94f6\u884c\u8054\u7cfb\u3002", (String)"PayParser_30", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021101008", ResManager.loadKDString((String)"\u5ba2\u6237\u53f7\u4e0d\u552f\u4e00\uff0c\u8bf7\u4e0e\u94f6\u884c\u8054\u7cfb\u3002", (String)"PayParser_31", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021101010", ResManager.loadKDString((String)"\u6b64\u4e1a\u52a1\u4e0d\u80fd\u901a\u8fc7\u5916\u8054\u8fdb\u884c\u4ea4\u6613\u3002", (String)"PayParser_32", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021101017", ResManager.loadKDString((String)"\u7528\u6237\u53f7\u672a\u8f93\u5165\uff0c\u8bf7\u6c42\u88ab\u53d6\u6d88\u3002", (String)"PayParser_33", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021101018", ResManager.loadKDString((String)"\u5ba2\u6237\u53f7\u4e0d\u5b58\u5728\u6216\u5ba2\u6237\u6ca1\u6709\u5f00\u901a\u5916\u8054\u5e73\u53f0\u4e1a\u52a1\u3002", (String)"PayParser_34", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021101019", ResManager.loadKDString((String)"\u7528\u6237\u53f7\u975e\u6cd5", (String)"PayParser_35", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021101021", ResManager.loadKDString((String)"\u7528\u6237\u8f93\u5165\u7684\u5bc6\u7801\u9519\u3002", (String)"PayParser_36", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021101028", ResManager.loadKDString((String)"\u6210\u5458\u884c\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"PayParser_37", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021101114", ResManager.loadKDString((String)"\u5ba2\u6237\u6ca1\u6709\u5f00\u901a\u5916\u8054\u5e73\u53f0\u4e1a\u52a1\u3002", (String)"PayParser_38", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021101115", ResManager.loadKDString((String)"\u5ba2\u6237IP\u5730\u5740\u6821\u9a8c\u4e0d\u7b26\u3002", (String)"PayParser_39", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021108005", ResManager.loadKDString((String)"\u8bc1\u4e66\u4e0d\u6b63\u786e", (String)"PayParser_40", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021108008", ResManager.loadKDString((String)"\u6682\u505c\u6b64\u9879\u7f51\u4e0a\u670d\u52a1\u3002", (String)"PayParser_41", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021108010", ResManager.loadKDString((String)"\u8bf7\u6c42\u7684\u4ea4\u6613\u4e0d\u5b58\u5728\u3002", (String)"PayParser_42", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021108014", ResManager.loadKDString((String)"\u8d85\u51fa\u672c\u65e5\u5931\u8d25\u6b21\u6570\u3002", (String)"PayParser_43", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021108015", ResManager.loadKDString((String)"\u8d85\u51fa\u603b\u5171\u5931\u8d25\u6b21\u6570\u3002", (String)"PayParser_44", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021108902", ResManager.loadKDString((String)"\u65e0\u53ef\u64cd\u4f5c\u7684\u8d26\u53f7\u3002", (String)"PayParser_45", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021108904", ResManager.loadKDString((String)"\u4ea4\u6613\u8d85\u8fc7\u8be5\u5206\u884c\u5355\u7b14\u7f51\u4e0a\u4ea4\u6613\u9650\u989d\u3002", (String)"PayParser_46", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021108905", ResManager.loadKDString((String)"\u4ea4\u6613\u8d85\u8fc7\u8be5\u5206\u884c\u5f53\u65e5\u7f51\u4e0a\u4ea4\u6613\u7d2f\u8ba1\u9650\u989d\u3002", (String)"PayParser_47", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021108908", ResManager.loadKDString((String)"IP\u5730\u5740\u975e\u6cd5", (String)"PayParser_48", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021108909", ResManager.loadKDString((String)"\u8f6c\u5165\u8d26\u6237\u975e\u7ea6\u5b9a\u8d26\u6237\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PayParser_49", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021108916", ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u5173\u95ed\uff0c\u4ea4\u6613\u65e0\u6cd5\u8fdb\u884c", (String)"PayParser_50", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021109045", ResManager.loadKDString((String)"\u4ea4\u6613\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PayParser_51", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021109061", ResManager.loadKDString((String)"\u5c1a\u672a\u7b7e\u7ea6\uff0c\u8bf7\u5230\u5f53\u5730\u94f6\u884c\u529e\u7406\u76f8\u5173\u624b\u7eed\u3002", (String)"PayParser_52", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021109062", ResManager.loadKDString((String)"\u8be5\u5ba2\u6237\u5df2\u7ecf\u88ab\u6ce8\u9500\uff0c\u4e0d\u80fd\u8fdb\u884c\u4ea4\u6613\u3002", (String)"PayParser_53", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021109064", ResManager.loadKDString((String)"\u64cd\u4f5c\u5458\u5df2\u88ab\u51bb\u7ed3\uff0c\u4e0d\u80fd\u8fdb\u884c\u4ea4\u6613\u3002\u8bf7\u5411\u4e3b\u7ba1\u54a8\u8be2\u6709\u5173\u60c5\u51b5\u3002", (String)"PayParser_54", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021109065", ResManager.loadKDString((String)"\u64cd\u4f5c\u5458\u5df2\u88ab\u51bb\u7ed3\u6216\u6ce8\u9500\uff0c\u4e0d\u80fd\u8fdb\u884c\u4ea4\u6613\u3002\u8bf7\u5411\u4e3b\u7ba1\u54a8\u8be2\u6709\u5173\u60c5\u51b5\u3002", (String)"PayParser_55", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("013021109067", ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650", (String)"PayParser_56", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("01302110B122", ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u8d26\u6237\u8f6c\u8d26\u6743\u9650\u3002", (String)"PayParser_57", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("01302110B317", ResManager.loadKDString((String)"\u5e10\u53f7\u975e\u6cd5", (String)"PayParser_58", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("01302110B319", ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u8d26\u6237\u7684\u8f6c\u8d26\u6743\u9650\u3002", (String)"PayParser_59", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("01302110B31A", ResManager.loadKDString((String)"\u4ee3\u53d1\u4ee3\u6263\u6587\u4ef6\u91d1\u989d\u683c\u5f0f\u9519\u3002", (String)"PayParser_60", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("01302110B323", ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u4ee3\u53d1\u4ee3\u6263\u6a21\u677f", (String)"PayParser_61", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("01302110B355", ResManager.loadKDString((String)"\u6279\u91cf\u4ee3\u53d1\u4ee3\u6263\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\u3002", (String)"PayParser_62", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("01302110B355", ResManager.loadKDString((String)"\u6279\u91cf\u4ee3\u53d1\u4ee3\u6263\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\u3002", (String)"PayParser_62", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("01302110W001", ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u9519\u8bef", (String)"PayParser_63", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("01302110W003", ResManager.loadKDString((String)"\u672a\u627e\u5230\u5916\u8fde\u5e73\u53f0\u5e10\u6237\u4fe1\u606f\u8868\u4fe1\u606f\u3002", (String)"PayParser_64", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("01302110W004", ResManager.loadKDString((String)"\u5355\u7b14\u91d1\u989d\u8d85\u8fc7\u9650\u989d\u3002", (String)"PayParser_65", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("01302110W005", ResManager.loadKDString((String)"\u6bcf\u5929\u91d1\u989d\u8d85\u8fc7\u9650\u989d\u3002", (String)"PayParser_66", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("WLPT_Err1004", ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u5f00\u901a\uff0c\u8bf7\u6c42\u88ab\u62d2\u7edd\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u3002", (String)"PayParser_67", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE1008", ResManager.loadKDString((String)"\u91d1\u989d\u8d85\u900f\u652f\u989d\u5ea6\u3002", (String)"PayParser_68", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE1085", ResManager.loadKDString((String)"\u6302\u5931\u6807\u5fd7\u4e0d\u6b63\u786e\u3002", (String)"PayParser_69", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE1409", ResManager.loadKDString((String)"\u5ba2\u6237\u5e10\u53f7\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"PayParser_70", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE2001", ResManager.loadKDString((String)"\u6b64\u4ea4\u6613\u4e0d\u5141\u8bb8\u8de8\u4e00\u7ea7\u884c\u4e4b\u95f4\u901a\u5151\u3002", (String)"PayParser_71", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE2021", ResManager.loadKDString((String)"\u6b64\u4ea4\u6613\u4e0d\u5141\u8bb8\u8de8\u4e00\u7ea7\u884c\u4e4b\u95f4\u901a\u5151\u3002", (String)"PayParser_71", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE2116", ResManager.loadKDString((String)"\u5185\u90e8\u5f52\u7ea6\u5e10\u53f7\u5fc5\u987b\u4e3a\u5185\u90e8\u5e10\u3002", (String)"PayParser_72", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE2204", ResManager.loadKDString((String)"\u652f\u53d6\u672c\u91d1>\u5b9e\u9645\u91d1\u989d\u3002", (String)"PayParser_73", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE3001", ResManager.loadKDString((String)"\u5e01\u79cd\u6216\u949e\u6c47\u9274\u522b\u4e0d\u5b58\u5728\u3002", (String)"PayParser_74", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE3024", ResManager.loadKDString((String)"\u5361\u53f7\u4e0d\u5b58\u5728", (String)"PayParser_75", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE3054", ResManager.loadKDString((String)"\u673a\u6784\u8d44\u6599\u672a\u627e\u5230\uff0e\u3002", (String)"PayParser_76", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE3055", ResManager.loadKDString((String)"\u8be5\u652f\u4ed8\u8054\u884c\u53f7\u4e0d\u751f\u6548\u3002", (String)"PayParser_77", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE3158", ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d\u4e0d\u8db3", (String)"PayParser_78", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE3250", ResManager.loadKDString((String)"\u5ba2\u6237\u7f16\u53f7+\u5730\u5740\u4ee3\u7801\u4e0d\u5b58\u5728\u3002", (String)"PayParser_79", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE3370", ResManager.loadKDString((String)"\u5361\u516c\u7528\u6863\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002", (String)"PayParser_80", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE3521", ResManager.loadKDString((String)"\u4eba\u884c\u5173\u7f51\u65f6\u95f4\u5230\u3002", (String)"PayParser_81", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE3540", ResManager.loadKDString((String)"\u6ce8\u9500\u72b6\u6001\u4e0d\u6b63\u786e\u3002", (String)"PayParser_82", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE3556", ResManager.loadKDString((String)"\u5361\u72b6\u6001\u4e0d\u6b63\u5e38", (String)"PayParser_83", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE4500", ResManager.loadKDString((String)"\u5e10\u6237\u63a7\u5236\u72b6\u6001\u4e0d\u5141\u8bb8\u652f\u53d6", (String)"PayParser_84", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE4501", ResManager.loadKDString((String)"\u5e10\u6237\u63a7\u5236\u72b6\u6001\u4e0d\u5141\u8bb8\u5b58\u5165\u3002", (String)"PayParser_85", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE5002", ResManager.loadKDString((String)"\u5361\u5df2\u6302\u5931", (String)"PayParser_86", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE7100", ResManager.loadKDString((String)"\u4f59\u989d\u4e0d\u8db3\uff0c\u53ef\u7528\u4f59\u989d\u3002", (String)"PayParser_87", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE7102", ResManager.loadKDString((String)"\u4f59\u989d\u4e0d\u8db3\uff0c\u53ef\u7528\u4f59\u989d\u3002", (String)"PayParser_87", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE8201", ResManager.loadKDString((String)"\u5e10\u6237\u5df2\u9500\u6237", (String)"PayParser_88", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE8301", ResManager.loadKDString((String)"\u8be5\u5361\u5df2\u9500\u6237", (String)"PayParser_89", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXE8720", ResManager.loadKDString((String)"\u65e0\u6298\u8d26\u53f7\uff0c\u4e0d\u5141\u8bb8\u4ea4\u6613\u3002", (String)"PayParser_90", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0010ZXXESA01", ResManager.loadKDString((String)"\u5e10\u53f7\u672a\u8bc6\u522b\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4e3a\u65e7\u5e10\u53f7\u3002", (String)"PayParser_91", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0130Z110B477", ResManager.loadKDString((String)"\u5236\u5355\u91d1\u989d\u8d85\u51fa\u5f53\u5929\u7d2f\u8ba1\u6388\u6743\u8f6c\u8d26\u9650\u989d\u3002", (String)"PayParser_92", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
        PayParser.put("0130Z110B481", ResManager.loadKDString((String)"\u5236\u5355\u91d1\u989d\u8d85\u51fa\u7d2f\u8ba1\u6388\u6743\u8f6c\u8d26\u9650\u989d\u3002", (String)"PayParser_93", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]));
    }
}

