/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment.oversea;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.aqap.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.aqap.banks.ccb.dc.services.payment.oversea.QueryPaymentImpl;
import kd.ebg.aqap.banks.ccb.dc.services.payment.oversea.StaticMapUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        Element header = CCB_DC_Packer.createTransactionHeader("NW3401", info.getBankBatchSeqId());
        Element txInfo = JDomUtils.addChild((Element)header, (String)"TX_INFO");
        JDomUtils.addChild((Element)txInfo, (String)"CstPty_TxnSrlNo", (String)info.getBankBatchSeqId());
        JDomUtils.addChild((Element)txInfo, (String)"StlMe_Cd", (String)"08");
        JDomUtils.addChild((Element)txInfo, (String)"MsgRp_Prty_Cd", (String)(info.getUrgent() != false ? "02" : "01"));
        if ("CHN".equals(info.getIncomeCountry())) {
            JDomUtils.addChild((Element)txInfo, (String)"FrnCy_Py_Obj_Cd", (String)"02");
        } else {
            JDomUtils.addChild((Element)txInfo, (String)"FrnCy_Py_Obj_Cd", (String)"03");
        }
        JDomUtils.addChild((Element)txInfo, (String)"CshEx_Cd", (String)"2");
        JDomUtils.addChild((Element)txInfo, (String)"Rmt_Psn_Nm", (String)info.getAccName());
        JDomUtils.addChild((Element)txInfo, (String)"Rmt_Psn_Adr", (String)info.getPayerAddress());
        JDomUtils.addChild((Element)txInfo, (String)"Exg_AccNo", (String)info.getAccNo());
        JDomUtils.addChild((Element)txInfo, (String)"Rmt_CcyCd", (String)StaticMapUtil.getCurrency(info.getCurrency()));
        JDomUtils.addChild((Element)txInfo, (String)"ValDt", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"FrnCy_Py_Rmt_Amt", (String)info.getAmount().toString());
        JDomUtils.addChild((Element)txInfo, (String)"RcvPymtPs_Nm", (String)info.getIncomeAccName());
        JDomUtils.addChild((Element)txInfo, (String)"RcvPymtPs_Adr", (String)info.getIncomeAddress());
        JDomUtils.addChild((Element)txInfo, (String)"FrnCy_RcvPymtPs_AccNo", (String)info.getIncomeAccNo());
        JDomUtils.addChild((Element)txInfo, (String)"RPPDBnkSWIFT_Cd", (String)info.getIncomeSwiftCode());
        JDomUtils.addChild((Element)txInfo, (String)"RPPDBnk", (String)info.getIncomeBankName());
        JDomUtils.addChild((Element)txInfo, (String)"RPPDBnk_Adr", (String)info.getIncomeBankAddress());
        JDomUtils.addChild((Element)txInfo, (String)"RPPDBnk_AccNo", (String)info.getIncomeAccNo());
        JDomUtils.addChild((Element)txInfo, (String)"RPPDBnk_AgncBnk_AccNo", (String)info.getProxyAccNo());
        JDomUtils.addChild((Element)txInfo, (String)"RcvPymtPs_RtCtyRgn_Cd", (String)info.getIncomeCountry());
        JDomUtils.addChild((Element)txInfo, (String)"RPyBk_AgncBnk_Nm", (String)info.getProxyBankName());
        JDomUtils.addChild((Element)txInfo, (String)"RPyBk_AgncBnk_Adr", (String)info.getProxyBankAddress());
        JDomUtils.addChild((Element)txInfo, (String)"RPyBk_AgncBnkSWIFT_Cd", (String)info.getProxyBankSwiftCode());
        if ("0".equals(info.getPayProperty())) {
            JDomUtils.addChild((Element)txInfo, (String)"Py_Char_Cd", (String)"01");
        } else if ("1".equals(info.getPayProperty())) {
            JDomUtils.addChild((Element)txInfo, (String)"Py_Char_Cd", (String)"02");
        } else if ("2".equals(info.getPayProperty())) {
            JDomUtils.addChild((Element)txInfo, (String)"Py_Char_Cd", (String)"03");
        } else {
            JDomUtils.addChild((Element)txInfo, (String)"Py_Char_Cd", (String)"04");
        }
        if (info.isBondGoodsFlag()) {
            JDomUtils.addChild((Element)txInfo, (String)"DlTax_GdItm_Py_Ind", (String)"1");
        } else {
            JDomUtils.addChild((Element)txInfo, (String)"DlTax_GdItm_Py_Ind", (String)"0");
        }
        if ("01".equals(info.getPayerFeeType())) {
            JDomUtils.addChild((Element)txInfo, (String)"DlTax_GdItm_Py_Ind", (String)"0");
        } else if ("02".equals(info.getPayerFeeType())) {
            JDomUtils.addChild((Element)txInfo, (String)"DlTax_GdItm_Py_Ind", (String)"2");
        } else if ("03".equals(info.getPayerFeeType())) {
            JDomUtils.addChild((Element)txInfo, (String)"DlTax_GdItm_Py_Ind", (String)"3");
        }
        JDomUtils.addChild((Element)txInfo, (String)"Cmsn_ChrgFee_AccNo", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Cost_CcyCd", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Rmt_Pstcrpt", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Rmt_Rmrk", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Itnl_IcmEpd_Txn_ECD_1", (String)info.getTxCode());
        JDomUtils.addChild((Element)txInfo, (String)"Crspd_CcyCd_1", (String)StaticMapUtil.getCurrency(info.getCurrency()));
        JDomUtils.addChild((Element)txInfo, (String)"Crspd_Amt_1", (String)info.getTxAmount());
        JDomUtils.addChild((Element)txInfo, (String)"Txn_Pstcrpt_1", (String)info.getTxPostscript());
        JDomUtils.addChild((Element)txInfo, (String)"Itnl_IcmEpd_Txn_ECD_2", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Crspd_CcyCd_2", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Crspd_Amt_2", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Txn_Pstcrpt_2", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Fil_Psn_Nm", (String)info.getApplyName());
        JDomUtils.addChild((Element)txInfo, (String)"Fil_Psn_Tel", (String)info.getApplyPhone());
        JDomUtils.addChild((Element)txInfo, (String)"Pymt_Char_Cd", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Fil_Psn_Tel", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Pymt_Char_Cd", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"AtLst_ShDt", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Fx_Rmt_Ctr_No", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Inv_ID", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"ExOff_ADNum", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Dcl_Bl_Oprt_UnCd", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"PrpyPymFrGsOcpCtrPctg", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Dcln_Frcst_Dys", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Dcln_RcvPy_TpCd", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Com_Trd_Amt", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"ChgIn_Pcs_Amt", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Othr_Trd_Amt", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Brdr_Trd_Amt", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Dcln_Unit_Nm", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"OrCd", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"XBdPy_Bsn_ID", (String)"");
        JDomUtils.addChild((Element)txInfo, (String)"Rvl_Rcrd_Num", (String)"0");
        String encoding = EBContext.getContext().getCharsetName();
        return JDomUtils.root2String((Element)header, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if ("000000".equalsIgnoreCase(response.getResponseCode())) {
            Element txInfo = root.getChild("TX_INFO");
            String CshMgt_Txn_Rslt_Cd = txInfo.getChildTextTrim("CshMgt_Txn_Rslt_Cd");
            String Err_Inf = txInfo.getChildTextTrim("CshMgt_Txn_Rslt_Cd");
            if ("1".equals(CshMgt_Txn_Rslt_Cd) || "2".equals(CshMgt_Txn_Rslt_Cd) || "3".equals(CshMgt_Txn_Rslt_Cd) || "e".equals(CshMgt_Txn_Rslt_Cd)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayParser_3", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)Err_Inf);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5\uff0c\u54cd\u5e94\u7801\uff1a%s\u3002", (String)"PayParser_95", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), response.getResponseCode()), (String)response.getResponseCode(), (String)Err_Inf);
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u77e5\uff0c\u54cd\u5e94\u7801\uff1a%s\u3002", (String)"PayParser_95", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]), response.getResponseCode()), (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "NW3401";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5916\u6c47\u6c47\u6b3e\u5355\u7b14\u7533\u8bf7", (String)"PaymentImpl_100", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

