/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.alipay.cmp.service.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.request.AlipayDataDataserviceBillDownloadurlQueryRequest;
import com.alipay.api.response.AlipayDataDataserviceBillDownloadurlQueryResponse;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.alipay.cmp.AlipayBusinessConfig;
import kd.ebg.aqap.banks.alipay.cmp.utils.AlipayRequestUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.lang.StringEscapeUtils;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);
    private final int BUFFER_SIZE = 1024;

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        BankAcnt acnt = request.getAcnt();
        if (!DateUtil.isSameDay((LocalDate)startDate, (LocalDate)endDate)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e0d\u540c\uff0c\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u63a5\u53e3\u4e00\u6b21\u53ea\u80fd\u83b7\u53d6\u4e00\u5929\u7684\u6570\u636e\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]));
        }
        List<DetailInfo> result = this.downLoadDetail(startDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")), acnt);
        EBBankDetailResponse ebBankDetailResponse = new EBBankDetailResponse();
        ebBankDetailResponse.setDetails(result);
        return ebBankDetailResponse;
    }

    private List<DetailInfo> downLoadDetail(String billDate, BankAcnt acnt) {
        AlipayDataDataserviceBillDownloadurlQueryResponse response;
        this.logger.info("\u51c6\u5907\u8c03\u7528\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u4e0b\u8f7d\u63a5\u53e3");
        AlipayDataDataserviceBillDownloadurlQueryRequest request = new AlipayDataDataserviceBillDownloadurlQueryRequest();
        HashMap<String, String> params = new HashMap<String, String>(16);
        String billType = "signcustomer";
        params.put("bill_type", "signcustomer");
        params.put("bill_date", billDate);
        request.setBizContent(JSON.toJSONString(params));
        this.logger.info("\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u4e0b\u8f7d\u8bf7\u6c42\u62a5\u6587:{}", (Object)request.getBizContent());
        try {
            response = (AlipayDataDataserviceBillDownloadurlQueryResponse)AlipayRequestUtil.execute(request, acnt.getAccNo());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8c03\u7528\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u4e0b\u8f7d\u63a5\u53e3\u53d1\u751f\u5f02\u5e38\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), (Throwable)e);
        }
        if (!response.isSuccess()) {
            if (response.getSubCode() != null && response.getSubCode().contains("bill_not_exist")) {
                this.logger.info(String.format("\u5f53\u65e5\u652f\u4ed8\u5b9d\u8d26\u5355\u4e0d\u5b58\u5728,\u652f\u4ed8\u5b9d\u8fd4\u56de%1$s", response.getSubCode()));
                return new ArrayList<DetailInfo>();
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8c03\u7528\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u4e0b\u8f7d\u63a5\u53e3\u5931\u8d25\uff0c\u652f\u4ed8\u5b9d\u7f51\u5173\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%2$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%3$s\u3002", (String)"DetailImpl_18", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), response.getMsg(), response.getSubCode(), response.getSubMsg()));
        }
        this.logger.info("\u652f\u4ed8\u5b9d\u7f51\u5173\u8fd4\u56de\u7684\u5bf9\u8d26\u5355\u4e0b\u8f7d\u5730\u5740\uff1a", (Object)response.getBillDownloadUrl());
        String path = this.downLoadFile(response.getBillDownloadUrl());
        return this.parseCSV(path, acnt);
    }

    private List<DetailInfo> parseCSV(String path, BankAcnt acnt) {
        BufferedReader br;
        this.logger.info("\u5f00\u59cb\u89e3\u6790\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355csv\u6587\u4ef6,\u8def\u5f84\uff1a{}", (Object)path);
        File csv = FileCommonUtils.getFileByPath((String)path);
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csv), "GBK"));
        }
        catch (FileNotFoundException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u6587\u4ef6\u4e0d\u5b58\u5728\uff01\u6587\u4ef6\u8def\u5f84\uff1a%s\u3002", (String)"DetailImpl_19", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), path), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7f16\u53f7", (String)"DetailImpl_6", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), (Throwable)e);
        }
        String line = "";
        String everyLine = "";
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>(1);
        try {
            int count = 0;
            boolean flag = false;
            String implClassName = DetailImpl.class.getName();
            while (!StringUtils.isEmpty((String)(line = br.readLine())) && !(everyLine = line).contains(PropertiesConstants.getValue((String)"DETAIL_END"))) {
                if (count == 5) {
                    flag = true;
                }
                if (flag) {
                    this.logger.info("\u652f\u4ed8\u5b9d\u660e\u7ec6===" + everyLine);
                    DetailInfo info = new DetailInfo();
                    String[] str = everyLine.split(",");
                    for (int i = 0; i < str.length; ++i) {
                        str[i] = str[i].replaceAll("\t", "");
                    }
                    info.setId(Sequence.gen18Sequence());
                    info.setBankVersionID(acnt.getBankVersionId());
                    info.setBankLoginID(acnt.getBankLoginId());
                    info.setCurrency(acnt.getCurrency());
                    info.setImplClassName(implClassName);
                    info.setHistory(Boolean.valueOf(true));
                    BigDecimal big = new BigDecimal(str[6]);
                    if (big.compareTo(BigDecimal.ZERO) == 0) {
                        info.setDebitAmount(new BigDecimal(str[7]).abs());
                        info.setCreditAmount(BigDecimal.ZERO);
                    } else {
                        info.setDebitAmount(BigDecimal.ZERO);
                        info.setCreditAmount(big.abs());
                    }
                    info.setUseCn(PropertiesConstants.getValue((String)"ONLINE_PAY"));
                    info.setAccNo(acnt.getAccNo());
                    info.setAccName(acnt.getAccName());
                    info.setBankName(acnt.getBankName());
                    if (str[5].contains("(") && str[5].contains(")")) {
                        info.setOppAccName(str[5].substring(0, str[5].lastIndexOf("(")));
                        info.setOppAccNo(str[5].substring(str[5].lastIndexOf("(") + 1, str[5].lastIndexOf(")")));
                    } else {
                        info.setOppAccName(str[5]);
                    }
                    info.setOppBankName(str[9]);
                    LocalDateTime transTime = LocalDateTime.parse(str[4], DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    info.setTransDate(transTime.toLocalDate());
                    info.setTransTime(transTime);
                    info.setTransType("normal");
                    info.setBalance(new BigDecimal(str[8]));
                    String exp = "";
                    if (str.length > 11) {
                        exp = StringUtils.trim((String)str[11]);
                    }
                    if (!StringUtils.isEmpty((String)exp) && exp.indexOf("KD_") != -1) {
                        String bankDetailSeqId = exp.substring(0, exp.indexOf("KD_"));
                        DetailSysFiled.set((DetailInfo)info, (String)"KDRetFlag", (String)bankDetailSeqId);
                        info.setPayBankDetailSeqID(bankDetailSeqId);
                        exp = exp.substring(exp.indexOf("KD_") + "KD_".length());
                        info.setExplanation(exp);
                    } else {
                        info.setExplanation(exp);
                    }
                    DetailSysFiled.set((DetailInfo)info, (String)"accountsNo", (String)str[0]);
                    DetailSysFiled.set((DetailInfo)info, (String)"businessOrderNo", (String)str[2]);
                    DetailSysFiled.set((DetailInfo)info, (String)"goodsName", (String)str[3]);
                    info.setBankDetailNo(str[0]);
                    info.setBusType(str[10]);
                    info.setBizRefNo(StringUtils.trim((String)str[1]));
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("transferDate", (Object)LocalDateUtil.formatDate((LocalDate)info.getTransDate(), (String)"yyyy-MM-dd"));
                    jsonObject.put("transferFlowNo", (Object)str[0]);
                    jsonObject.put("debitAmount", (Object)str[7]);
                    jsonObject.put("creditAmount", (Object)str[6]);
                    info.setJsonMap(jsonObject.toJSONString());
                    info.setBankDetailNo(str[0]);
                    if (AlipayBusinessConfig.isNewDetailSerialNoConfig()) {
                        info.setBankDetailNo(str[2]);
                    }
                    list.add(info);
                }
                ++count;
            }
            this.logger.info("\u89e3\u6790\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355csv\u6587\u4ef6\u5b8c\u6210\uff0c\u6210\u529f\u89e3\u6790\u5230{}\u6761\u8bb0\u5f55", (Object)list.size());
            ArrayList<DetailInfo> arrayList = list;
            return arrayList;
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790csv\u6587\u4ef6\u5f02\u5e38\u3002", (String)"DetailImpl_7", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), (Throwable)e);
        }
        catch (DateTimeParseException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\u3002", (String)"DetailImpl_8", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage());
                }
            }
            if (csv.exists()) {
                File parentFile;
                this.logger.info("\u89e3\u6790\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355csv\u5b8c\u6210\uff0c\u5220\u9664\u539f\u6587\u4ef6:{}", (Object)csv.getAbsolutePath());
                if (!csv.delete()) {
                    this.logger.error("\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355csv\u5220\u9664\u5931\u8d25");
                }
                if ((parentFile = csv.getParentFile()).isDirectory() && parentFile.exists()) {
                    this.logger.info("\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355csv\u7236\u76ee\u5f55\u5b58\u5728\uff0c\u5f00\u59cb\u5220\u9664\u76ee\u5f55:{}", (Object)parentFile.getAbsolutePath());
                    if (!parentFile.delete()) {
                        this.logger.error("\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355csv\u7236\u76ee\u5f55\u5220\u9664\u5931\u8d25");
                    }
                }
            }
        }
    }

    private String downLoadFile(String billDownloadUrl) {
        if ("-1".equalsIgnoreCase(String.valueOf(billDownloadUrl.indexOf("downloadFileName")))) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u4e0b\u8f7d\u5730\u5740\u6ca1\u6709\u5305\u542bdownloadFileName\u5b57\u6bb5\uff0c\u5730\u5740\uff1a%s\u3002", (String)"DetailImpl_20", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), billDownloadUrl));
        }
        billDownloadUrl = billDownloadUrl.replaceAll("\\\\", "");
        billDownloadUrl = StringEscapeUtils.unescapeHtml((String)billDownloadUrl);
        String str = billDownloadUrl.substring(billDownloadUrl.indexOf("downloadFileName"));
        String fileName = str.substring(str.indexOf("=") + 1, str.indexOf("&"));
        String dir = RequestContextUtils.getBankParameterValue((String)"bill_files_dir") + File.separator + EBContext.getContext().getCustomID();
        try {
            this.downLoadFromUrl(billDownloadUrl, fileName, dir);
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ece\u5bf9\u8d26\u5355\u4e0b\u8f7d\u5730\u5740\u4e0b\u8f7d\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u5730\u5740\uff1a%s\u3002", (String)"DetailImpl_21", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), billDownloadUrl), (Throwable)e);
        }
        File file = FileCommonUtils.getFileByPath((String)(dir + File.separator + fileName));
        try {
            if (!file.exists()) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a%1$s%2$s\u3002", (String)"DetailImpl_22", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), dir, fileName));
            }
            String path = dir + File.separator + fileName.substring(0, fileName.indexOf("."));
            File pathFile = FileCommonUtils.getFileByPath((String)path);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            String string = this.unZip(dir + File.separator + fileName, path);
            return string;
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u538b\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\u3002", (String)"DetailImpl_12", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            if (file.exists()) {
                this.logger.info("\u89e3\u538b\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u6587\u4ef6\u5b8c\u6210\uff0c\u5f00\u59cb\u5220\u9664\u539f\u6587\u4ef6:{}", (Object)file.getAbsolutePath());
                if (!file.delete()) {
                    this.logger.info("\u89e3\u538b\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u6587\u4ef6\u5220\u9664\u5931\u8d25");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String unZip(String path, String destDirPath) throws IOException {
        this.logger.info("\u5f00\u59cb\u89e3\u538b\u5bf9\u8d26\u5355\u538b\u7f29\u5305,\u538b\u7f29\u5305\u8def\u5f84\uff1a{}", (Object)path);
        String detailFile = null;
        try (ZipFile zipFile = FileCommonUtils.getZipFileByPath((String)path, (Charset)Charset.forName("GBK"));){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String dirPath = destDirPath + "/" + entry.getName();
                if (!entry.getName().endsWith(PropertiesConstants.getValue((String)"DETAIL_CSV"))) continue;
                detailFile = dirPath;
                if (entry.isDirectory()) {
                    FileCommonUtils.getFileByPath((String)dirPath).mkdirs();
                    break;
                }
                File targetFile = FileCommonUtils.getFileByPath((String)dirPath);
                if (!targetFile.createNewFile()) {
                    this.logger.error("\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
                }
                try (InputStream is = zipFile.getInputStream(entry);
                     FileOutputStream fos = new FileOutputStream(targetFile);){
                    int len;
                    byte[] buf = new byte[1024];
                    while ((len = is.read(buf)) != -1) {
                        fos.write(buf, 0, len);
                    }
                    break;
                }
            }
            if (StringUtils.isEmpty(detailFile)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u538b\u5931\u8d25\uff0czip\u538b\u7f29\u5305\u5185\u6ca1\u6709\u6307\u5b9a\u683c\u5f0f\u7684csv\u6587\u4ef6\u3002", (String)"DetailImpl_13", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]));
            }
            this.logger.info("\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u538b\u7f29\u5305\u89e3\u538b\u5b8c\u6210");
            String string = detailFile;
            return string;
        }
        catch (Exception e) {
            this.logger.error("\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u538b\u7f29\u5305\u89e3\u538b\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u538b\u5931\u8d25", (String)"DetailImpl_14", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public void downLoadFromUrl(String urlStr, String fileName, String savePath) throws IOException {
        this.logger.info("\u5f00\u59cb\u4ece\u652f\u4ed8\u5b9d\u4e0b\u8f7d\u5bf9\u8d26\u5355\u6587\u4ef6,\u5730\u5740:{}", (Object)urlStr);
        try {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(3000);
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            try (InputStream inputStream = conn.getInputStream();){
                byte[] getData = this.readInputStream(inputStream);
                inputStream.close();
                if (getData[0] == 60 && getData[1] == 105 && getData[2] == 109 && getData[3] == 103) {
                    throw new IOException(ResManager.loadKDString((String)"\u652f\u4ed8\u5b9d\u8fd4\u56de\u4e0b\u8f7d\u8d85\u65f6\u3002", (String)"DetailImpl_15", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]));
                }
                File saveDir = FileCommonUtils.getFileByPath((String)savePath);
                if (!saveDir.exists()) {
                    saveDir.mkdirs();
                }
                File file = FileCommonUtils.getFileByPath((String)(saveDir + File.separator + fileName));
                try (FileOutputStream fos = new FileOutputStream(file);){
                    fos.write(getData);
                }
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        this.logger.info("\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u4e0b\u8f7d\u6210\u529f");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readInputStream(InputStream inputStream) throws IOException {
        try {
            byte[] buffer = new byte[1024];
            int len = 0;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                while ((len = inputStream.read(buffer)) != -1) {
                    bos.write(buffer, 0, len);
                }
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankDetailResponse detail(BankDetailRequest request) {
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u652f\u4ed8\u5b9d\u4e0d\u652f\u6301\u67e5\u8be2\u5f53\u5929\u7684\u4ea4\u6613\u660e\u7ec6\u3002", (String)"DetailImpl_16", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]));
    }

    public String pack(BankDetailRequest request) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        return null;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "alipay_detail";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0b\u8f7d\u652f\u4ed8\u5b9d\u5bf9\u8d26\u5355\u5e76\u89e3\u6790\u5165\u5e93\u3002", (String)"DetailImpl_17", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]);
    }

    public boolean match(BankDetailRequest request) {
        return AlipayBusinessConfig.isUseUrl4Detail();
    }
}

