/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.uobsg.dc;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BankBusinessConfig
extends BankPropertyConfig {
    public static final PropertyConfigItem UOBSG_DC_BICCODE = PropertyConfigItem.builder().key("UOBSG_DC_BICCODE").mlName(new MultiLangEnumBridge("SWIFT CODE", "BankBusinessConfig_0", "ebg-aqap-banks-uobsg-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("SWFIT Code\uff08\u94f6\u884c\u56fd\u9645\u4ee3\u7801\uff09\uff1a\u8de8\u5883\u652f\u4ed8/\u5883\u5185\u5916\u5e01\u4e1a\u52a1\u4f7f\u7528\uff0c\u901a\u5e38\u75318\u621611\u4f4d\u6570\u5b57\u548c\u5b57\u6bcd\u7ec4\u6210\u3002", "BankBusinessConfig_10", "ebg-aqap-banks-uobsg-dc"), new MultiLangEnumBridge("\u6b64\u914d\u7f6e\u4f7f\u7528\u63a5\u53e3\u6709\uff1aFAST\u3001GIRO\u3001TT\u3001MEPS\u63a5\u53e3\u3002", "BankBusinessConfig_12", "ebg-aqap-banks-uobsg-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem UOBSG_DC_BANKCITY = PropertyConfigItem.builder().key("UOBSG_DC_BANKCITY").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u94f6\u884c\u56fd\u5bb6/\u5730\u533a", "BankBusinessConfig_1", "ebg-aqap-banks-uobsg-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u94f6\u884c\u56fd\u5bb6/\u5730\u533a\uff0c\u8bf7\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5b57\u6bcd\u7b80\u5199\uff0c\u6bd4\u5982 CN\u3001US\u3001SG", "BankBusinessConfig_11", "ebg-aqap-banks-uobsg-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem UOBSG_DC_PAY_COMPANY_ACNT = PropertyConfigItem.builder().key("UOBSG_DC_PAY_COMPANY_ACNT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_2", "ebg-aqap-banks-uobsg-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_2", "ebg-aqap-banks-uobsg-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem UOBSG_DC_PAY_COMPANY_STREET_ACNT = PropertyConfigItem.builder().key("UOBSG_DC_PAY_COMPANY_STREET_ACNT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u8857\u9053\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_3", "ebg-aqap-banks-uobsg-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u8857\u9053\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_3", "ebg-aqap-banks-uobsg-dc")})).isAccNo(true).build();
    private static final PropertyConfigItem UOBSG_DC_PAY_STATE_TIMEOUT = PropertyConfigItem.builder().key("UOBSG_DC_PAY_STATE_TIMEOUT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u72b6\u6001\u8d85\u65f6\u65f6\u95f4", "BankBusinessConfig_4", "ebg-aqap-banks-uobsg-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u63d0\u4ea4\u8d85\u8fc7\u914d\u7f6e\u7684\u65f6\u95f4\u672a\u5f97\u5230\u94f6\u884c\u54cd\u5e94\uff0c\u5c06\u4ed8\u6b3e\u72b6\u6001\u7f6e\u4e3a\u4ea4\u6613\u672a\u786e\u8ba4\u3002\u914d\u7f6e\u5927\u4e8e0\u7684\u6570\u5b57\uff0c\u5355\u4f4d\uff1a\u5c0f\u65f6\u3002\u4e0d\u8bbe\u7f6e\u5219\u4e0d\u4fee\u6539\u4ea4\u6613\u72b6\u6001\u3002", "BankBusinessConfig_5", "ebg-aqap-banks-uobsg-dc")})).build();
    public static final PropertyConfigItem UOBSG_DC_DEBTOR_IDENTIFICATION = PropertyConfigItem.builder().key("uobsg_dc_debtor_identification").mlName(new MultiLangEnumBridge("Company ID", "BankBusinessConfig_6", "ebg-aqap-banks-uobsg-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("Company ID \uff0c\u5982\u679c\u4e0e\u94f6\u884c\u5bf9\u63a5\u7684\u6a21\u5f0f\u4e3aInterOperability\uff0c\u8be5\u9879\u53ef\u4e3a\u7a7a\uff0c\u5426\u5219\uff0c\u6b64\u9879\u5fc5\u586b\uff0c\u7531\u94f6\u884c\u63d0\u4f9b\u3002", "BankBusinessConfig_7", "ebg-aqap-banks-uobsg-dc")})).isAccNo(true).build();
    private static final PropertyConfigItem UOBSG_DC_PAY = PropertyConfigItem.builder().key("uobsg_dc_pay").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u63a5\u53e3\u9009\u62e9", "BankBusinessConfig_27", "ebg-aqap-banks-uobsg-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u63a5\u53e3\u9009\u62e9:", "BankBusinessConfig_28", "ebg-aqap-banks-uobsg-dc"), new MultiLangEnumBridge("1)\u5355\u7b14\u4ed8\u6b3e\u63a5\u53e3\uff0c\u4ed8\u6b3e\u6587\u4ef6\u53ea\u5305\u62ec\u4e00\u7b14\u4ed8\u6b3e\u4fe1\u606f\u3002", "BankBusinessConfig_29", "ebg-aqap-banks-uobsg-dc"), new MultiLangEnumBridge("2)\u6279\u91cf\u4ed8\u6b3e\u63a5\u53e3\uff0c\u4ed8\u6b3e\u6587\u4ef6\u5305\u62ec\u591a\u7b14\u4ed8\u6b3e\u4fe1\u606f\uff0c\u660e\u7ec6\u5c06\u6c47\u805a\u6210\u4e00\u7b14\u4e14\u7f3a\u5931\u5bf9\u65b9\u4fe1\u606f\u3002", "BankBusinessConfig_30", "ebg-aqap-banks-uobsg-dc")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5355\u7b14\u4ed8\u6b3e\u63a5\u53e3", "BankBusinessConfig_31", "ebg-aqap-banks-uobsg-dc"), new MultiLangEnumBridge("\u6279\u91cf\u4ed8\u6b3e\u63a5\u53e3", "BankBusinessConfig_32", "ebg-aqap-banks-uobsg-dc")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"single", "batch"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"single"})).mustInput(Boolean.TRUE.booleanValue()).build();

    public boolean isForeignBank() {
        return true;
    }

    public static boolean singleOrBatch() {
        return "single".equalsIgnoreCase(UOBSG_DC_PAY.getCurrentValue());
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        List propertyConfigItems = this.getBankAddtionalPropertyConfigItems(false, false, false);
        ArrayList propertyConfigItems2 = Lists.newArrayList((Object[])new PropertyConfigItem[]{UOBSG_DC_BICCODE, UOBSG_DC_BANKCITY, UOBSG_DC_PAY_COMPANY_ACNT, UOBSG_DC_PAY_COMPANY_STREET_ACNT, UOBSG_DC_PAY_STATE_TIMEOUT, UOBSG_DC_DEBTOR_IDENTIFICATION, UOBSG_DC_PAY});
        propertyConfigItems.addAll(propertyConfigItems2);
        return propertyConfigItems;
    }

    public static String getBicCode(String accNo) {
        return UOBSG_DC_BICCODE.getCurrentValueWithObjectID(accNo);
    }

    public static String getLegalID(String accNo) {
        return UOBSG_DC_DEBTOR_IDENTIFICATION.getCurrentValueWithObjectID(accNo);
    }

    public static String getBankCity(String accNo) {
        String val = UOBSG_DC_BANKCITY.getCurrentValueWithObjectID(accNo);
        if (StringUtils.isEmpty((String)val)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c\u56fd\u5bb6/\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u4e91\u5e10\u53f7\u7ba1\u7406-\u9644\u52a0\u5c5e\u6027\u4e2d\u7ef4\u62a4\u3002", (String)"CommonPacker_2", (String)"ebg-aqap-banks-uobsg-dc", (Object[])new Object[0]));
        }
        if (val.length() > 3) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u56fd\u5bb6\u5b57\u6bcd\u7b80\u5199\u8fc7\u957f\uff0c\u8bf7\u6b63\u786e\u7ef4\u62a4\u3002", (String)"CommonPacker_3", (String)"ebg-aqap-banks-uobsg-dc", (Object[])new Object[0]));
        }
        return val;
    }

    public static String getPayCompany(String accNo) {
        return UOBSG_DC_PAY_COMPANY_ACNT.getCurrentValueWithObjectID(accNo);
    }

    public static String getPayCompanyStreet(String accNo) {
        return UOBSG_DC_PAY_COMPANY_STREET_ACNT.getCurrentValueWithObjectID(accNo);
    }

    public static int getPayStateTimeout() {
        String timeOut = UOBSG_DC_PAY_STATE_TIMEOUT.getCurrentValue();
        int timeout = 0;
        if (null != timeOut && timeOut.length() > 0) {
            try {
                if (Integer.parseInt(timeOut) > 0) {
                    timeout = Integer.parseInt(timeOut);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    public static boolean isPayStateTimeout(LocalDateTime submitSuccessTime) {
        int payStateTimeout = BankBusinessConfig.getPayStateTimeout();
        if (payStateTimeout <= 0) {
            return false;
        }
        LocalDateTime deadlineTime = submitSuccessTime.plus(payStateTimeout, ChronoUnit.HOURS);
        return deadlineTime.isBefore(LocalDateTime.now());
    }
}

