/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.uobsg.dc.services.payment.tt;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.uobsg.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.uobsg.dc.services.payment.CommonPacker;
import kd.ebg.aqap.banks.uobsg.dc.services.payment.querypay.QueryPayImpl;
import kd.ebg.aqap.banks.uobsg.dc.utils.Helper;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.aqap.proxy.oversea.bank.AbstractOverseaPayImpl;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PayImpl
extends AbstractOverseaPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(PayImpl.class);

    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getPayFileName(BankPayRequest request) {
        return Helper.getFileName();
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.createRoot((String)"Document");
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Namespace ns2 = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        root.setNamespace(ns1);
        root.addNamespaceDeclaration(ns2);
        Element CstmrCdtTrfInitn = JDomUtils.addChild((Element)root, (String)"CstmrCdtTrfInitn").setNamespace(ns1);
        Element GrpHdr = CommonPacker.packPayXmlhead(paymentInfos, CstmrCdtTrfInitn, ns1);
        Element PmtInf = CommonPacker.packPayXmlPmtInfo(paymentInfos, CstmrCdtTrfInitn);
        BigDecimal totalAmount = new BigDecimal("0.00");
        Helper helper = new Helper();
        for (PaymentInfo info : paymentInfos) {
            Element CdtTrfTxInf = JDomUtils.addChild((Element)PmtInf, (String)"CdtTrfTxInf").setNamespace(ns1);
            Element PmtId = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"PmtId").setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"InstrId", (String)info.getBankDetailSeqId()).setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"EndToEndId", (String)info.getBankDetailSeqId()).setNamespace(ns1);
            Element Amt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Amt").setNamespace(ns1);
            BigDecimal amount = info.getAmount();
            if ("overseaPay".equals(info.getSubBizType())) {
                amount = info.getActualAmount();
            }
            Element InstdAmt = JDomUtils.addChild((Element)Amt, (String)"InstdAmt", (String)amount.toString()).setNamespace(ns1);
            totalAmount = totalAmount.add(amount);
            String currency = info.getCurrency();
            if ("overseaPay".equals(info.getSubBizType())) {
                currency = info.getPayCurrency();
            }
            InstdAmt.setAttribute("Ccy", currency);
            if ("overseaPay".equals(info.getSubBizType())) {
                if (info.getPayerFeeType().equals("01")) {
                    JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"DEBT").setNamespace(ns1);
                } else if (info.getPayerFeeType().equals("02")) {
                    JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"CRED").setNamespace(ns1);
                } else if (info.getPayerFeeType().equals("03")) {
                    JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"SHAR").setNamespace(ns1);
                }
            } else if ("1".equals(info.getFeeType())) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"DEBT").setNamespace(ns1);
            } else if ("0".equals(info.getFeeType())) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"CRED").setNamespace(ns1);
            } else if ("2".equals(info.getFeeType())) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"SHAR").setNamespace(ns1);
            }
            Element CdtrAgt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAgt").setNamespace(ns1);
            Element CdtrAgt_FinInstnId = JDomUtils.addChild((Element)CdtrAgt, (String)"FinInstnId").setNamespace(ns1);
            if (!StringUtils.isEmpty((String)info.getIncomeSwiftCode())) {
                JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"BIC", (String)info.getIncomeSwiftCode()).setNamespace(ns1);
            }
            if (!StringUtils.isEmpty((String)info.getIncomeBankLocalClearingCode())) {
                Element ClrSysMmbId = JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"ClrSysMmbId").setNamespace(ns1);
                JDomUtils.addChild((Element)ClrSysMmbId, (String)"MmbId", (String)info.getIncomeBankLocalClearingCode()).setNamespace(ns1);
            }
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"Nm", (String)info.getIncomeBankName()).setNamespace(ns1);
            Element CdtrAgt_FinInstnId_PstlAdr = JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"PstlAdr").setNamespace(ns1);
            CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfo(info.getIncomeCountry());
            if (null == code && null == (code = ISOCountryUtils.getInstance().getCountryInfoByName(info.getIncomeCountry()))) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6\uff1a%1$s \u683c\u5f0f\u4e0d\u5bf9\uff0c\u6216\u672a\u80fd\u4ece\u56fd\u5bb6\u4ee3\u7801\u8868\u4e2d\u5339\u914d\u3002", (String)"PayImpl_0", (String)"ebg-aqap-banks-uobsg-dc", (Object[])new Object[0]), info.getIncomeCountry()));
            }
            String ctry = code.geteChart2();
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId_PstlAdr, (String)"Ctry", (String)ctry).setNamespace(ns1);
            String name = info.getIncomeAccName();
            Element Cdtr = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Cdtr").setNamespace(ns1);
            JDomUtils.addChild((Element)Cdtr, (String)"Nm", (String)helper.formatStringByLength(name, 35)).setNamespace(ns1);
            Element Cdtr_PstlAdr = JDomUtils.addChild((Element)Cdtr, (String)"PstlAdr").setNamespace(ns1);
            JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"Ctry", (String)ctry).setNamespace(ns1);
            helper.addressSplit(Cdtr_PstlAdr, info.getIncomeAddress(), ns1, 3);
            Element CdtrAcct = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAcct").setNamespace(ns1);
            Element CdtrAcct_Id = JDomUtils.addChild((Element)CdtrAcct, (String)"Id").setNamespace(ns1);
            Element CdtrAcct_Id_Othr = JDomUtils.addChild((Element)CdtrAcct_Id, (String)"Othr").setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAcct_Id_Othr, (String)"Id", (String)info.getIncomeAccNo()).setNamespace(ns1);
            String exp = info.getExplanation();
            String purposeCode = Helper.convert2PurposeCode(info, info.getUseCN());
            if (StringUtils.isEmpty((String)exp)) continue;
            Element RmtInf = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RmtInf").setNamespace(ns1);
            String tag3 = "3:";
            JDomUtils.addChild((Element)RmtInf, (String)"Ustrd", (String)("1:" + purposeCode)).setNamespace(ns1);
            List<String> list = Helper.getStrList(exp, 103);
            for (String string : list) {
                JDomUtils.addChild((Element)RmtInf, (String)"Ustrd", (String)(tag3 + string)).setNamespace(ns1);
            }
        }
        Element CtrlSum = GrpHdr.getChild("CtrlSum", ns1);
        CtrlSum.addContent(totalAmount.toString());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "TT";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return ("TT".equalsIgnoreCase(paymentInfo.getUseCN()) || "MEPS".equalsIgnoreCase(paymentInfo.getUseCN())) && !BankBusinessConfig.singleOrBatch();
    }
}

