/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.njb.dc.services.balance;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.njb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.njb.dc.utils.TCommon;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element ebank_root = new Element("ap");
        Element head = GLBPacker.getHeadPackerData("800855", "0");
        Element body = this.getBalanceRequestBody(bankBalanceRequest);
        JDomUtils.addChild((Element)ebank_root, (Element)head);
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String respStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return TCommon.createCommonMsg(respStr);
    }

    private Element getBalanceRequestBody(BankBalanceRequest request) throws EBServiceException {
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getHeader().getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"zhzhriqi", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return body;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String resp) {
        Element ebank_root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(resp), (String)RequestContextUtils.getCharset());
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        BalanceInfo balanceInfo = new BalanceInfo();
        Element head = ebank_root.getChild("head");
        String retCode = head.getChildText("ret_code");
        String succFlag = head.getChildText("succ_flag");
        String ret_info = head.getChildText("ret_info");
        if (!"0000".equalsIgnoreCase(retCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)retCode, (String)ret_info));
        }
        if (!"0".equalsIgnoreCase(succFlag)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)retCode, (String)ret_info));
        }
        Element body = ebank_root.getChild("body");
        String acno = body.getChildText("acno");
        this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), acno);
        String balance = body.getChildText("zhanghye");
        this.setCurrentBalance(balanceInfo, balance);
        balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
        balanceInfo.setBalanceDateTime(LocalDateTime.of(bankBalanceRequest.getStartDate(), LocalTime.MIN));
        balanceInfos.add(balanceInfo);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return "cqc";
    }

    public String getBizCode() {
        return "800855";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HisBalanceImpl_5", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]);
    }

    public LocalDate limitDate() {
        return null;
    }

    public int queryDays() {
        return 1;
    }
}

