/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.njb.dc.services.payment.otherbank;

import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.njb.dc.services.payment.otherbank.CompanyPayImpl;
import kd.ebg.aqap.banks.njb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.njb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.njb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayQueryImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(CompanyPayQueryImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "zhe_zhou";
    }

    public String getBizCode() {
        return "800051";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4f01\u4e1a\u4ea4\u6613\u6d41\u6c34", (String)"CompanyPayQueryImpl_0", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return info.getImplClassName().equals(CompanyPayImpl.class.getName());
    }

    public EBBankPayResponse queryPay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfolist = bankPayRequest.getPaymentInfos();
        PaymentInfo[] paymentInfos = new PaymentInfo[paymentInfolist.size()];
        paymentInfolist.toArray(paymentInfos);
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData("800051", "0"));
        Element body = new Element("body");
        String cms_corp_no = RequestContextUtils.getParameter().getBankParameter("cms_corp_no");
        String bankBatchSeqId = paymentInfos[0].getBankBatchSeqId();
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = paymentInfos[0].getRequestTime().atZone(zoneId);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String time = df.format(Date.from(zdt.toInstant()));
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)cms_corp_no);
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)"");
        JDomUtils.addChild((Element)body, (String)"req_no", (String)bankBatchSeqId);
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)time);
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)encoding);
        return TCommon.createCommonMsg(requestMessage);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfolist = bankPayRequest.getPaymentInfos();
        PaymentInfo[] paymentInfos = new PaymentInfo[paymentInfolist.size()];
        paymentInfolist.toArray(paymentInfos);
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(s), (String)encoding);
        Element head = bank_root.getChild("head");
        Element body = bank_root.getChild("body");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        if (!"0000".equals(bankStatus)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"CompanyPayQueryImpl_1", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
            log.info("\u4ea4\u6613\u672a\u786e\u8ba4");
        } else {
            String TransStatus = body.getChildTextTrim("stat");
            if ("9".equals(TransStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyPayQueryImpl_2", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), (String)bankStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyPayQueryImpl_2", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]));
                log.info("\u4ea4\u6613\u6210\u529f");
            } else if ("6".equals(TransStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyPayQueryImpl_3", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), (String)bankStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyPayQueryImpl_3", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]));
                log.info("\u4ea4\u6613\u5931\u8d25");
            } else if ("7".equals(TransStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u88ab\u62d2\u7edd", (String)"CompanyPayQueryImpl_4", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), (String)bankStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u88ab\u62d2\u7edd", (String)"CompanyPayQueryImpl_4", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]));
                log.info("\u4ea4\u6613\u88ab\u62d2\u7edd");
            } else if ("8".equals(TransStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyPayQueryImpl_5", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), (String)bankStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyPayQueryImpl_5", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]));
                log.info("\u4ea4\u6613\u7ed3\u679c\u672a\u77e5");
            }
        }
        return new EBBankPayResponse(paymentInfolist);
    }
}

