/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.njb.dc.services.payment.otherbank.batch;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.njb.dc.services.payment.otherbank.batch.CompanyBatchPayQueryImpl;
import kd.ebg.aqap.banks.njb.dc.services.proxy.FileProxy;
import kd.ebg.aqap.banks.njb.dc.utils.GLBPacker;
import kd.ebg.aqap.banks.njb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.njb.dc.utils.TCommon;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyBatchPayImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(CompanyBatchPayImpl.class);

    public int getBatchSize() {
        return 50;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyBatchPayQueryImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "300006";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u5bf9\u5916\u652f\u4ed8", (String)"CompanyBatchPayImpl_0", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.getTotalCount() > 1 && paymentInfo.is2Merge();
    }

    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfolist = bankPayRequest.getPaymentInfos();
        PaymentInfo[] paymentInfos = new PaymentInfo[paymentInfolist.size()];
        paymentInfolist.toArray(paymentInfos);
        log.info("\u6279\u91cf\u4ed8\u6b3e\u8bf7\u6c42\u5f00\u59cb...");
        Element ebank_root = new Element("ap");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData2("300006", paymentInfos, "1"));
        String bankBatchSeqId = paymentInfos[0].getBankBatchSeqId();
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)bankBatchSeqId);
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)body, (String)"pay_accaddr", (String)paymentInfos[0].getBankAddress());
        String content = "cert_type|cert_no|rcv_acno|rcv_code|rcv_acname|rcv_accaddr|amt|as_flag|as_acno|as_acname|rcv_bankno|rcv_bankname|bank_flag|area_flag|urgency_flag|purpose|postscript|booking_flag|booking_date|booking_time|mobiles|saverecvinfo_flag|\r\n";
        BigDecimal totalamt = new BigDecimal("0.00");
        StringBuilder stringBuilder = new StringBuilder(content);
        for (int i = 0; i < paymentInfos.length; ++i) {
            stringBuilder.append("|").append(bankBatchSeqId).append("|").append(paymentInfos[i].getIncomeAccNo()).append("|").append(paymentInfos[i].getCurrency()).append("|").append(paymentInfos[i].getIncomeAccName()).append("|").append("|").append(paymentInfos[i].getAmount().toString()).append("|").append("").append("|").append("").append("|").append("").append("|").append(paymentInfos[i].getIncomeCnaps()).append("|").append(paymentInfos[i].getIncomeBankName()).append("|").append(paymentInfos[i].is2SameBank() ? 0 : 1).append("|").append(paymentInfos[i].is2SameCity() ? 0 : 1).append("|").append(paymentInfos[0].is2Urgent() ? 0 : 1).append("|").append(paymentInfos[i].getExplanation()).append("|").append(paymentInfos[i].getExplanation()).append("|").append("").append("|").append("").append("|").append("|").append("|").append("|").append("\r\n");
            totalamt = totalamt.add(paymentInfos[i].getAmount());
        }
        content = stringBuilder.toString();
        JDomUtils.addChild((Element)body, (String)"count", (String)String.valueOf(paymentInfos.length));
        JDomUtils.addChild((Element)body, (String)"amt", (String)String.valueOf(totalamt));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)"");
        JDomUtils.addChild((Element)body, (String)"postscript", (String)ResManager.loadKDString((String)"\u6279\u91cf\u4ed8\u6b3e", (String)"CompanyBatchPayImpl_1", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]));
        JDomUtils.addChild((Element)body, (String)"Delay_flag", (String)ResManager.loadKDString((String)"\u6ede\u7559\u6807\u5fd7", (String)"CompanyBatchPayImpl_2", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]));
        Date now = new Date();
        String date = DateTimeUtils.format((Date)now, (String)"yyyyMMddHHmmss");
        String file_name = bankBatchSeqId + "@" + date;
        new FileProxy().upload(file_name, content);
        JDomUtils.addChild((Element)body, (String)"file_name", (String)file_name);
        String requestXml = JDomUtils.root2StringWithoutXMLDeclaration((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return TCommon.createCommonMsg(requestXml);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element bank_root = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)encoding);
        Element head = bank_root.getChild("head");
        BankResponse headRsp = GLBParser.parseHeader(head);
        String bankStatus = headRsp.getResponseCode();
        if ("0000".equals(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyBatchPayImpl_3", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"CompanyBatchPayImpl_4", (String)"ebg-aqap-banks-njb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }
}

