/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.njb.dc.utils;

import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class GLBParser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(GLBParser.class);

    public static BankResponse parseHeader(Element head) {
        BankResponse rsp = new BankResponse();
        String retCode = head.getChildTextTrim("ret_code");
        String retMsg = "";
        Element RetMsgElement = head.getChild("ret_info");
        String retmsg = head.getChildTextTrim("ret_info");
        if (retmsg != null && !"".equals(retmsg)) {
            String retMessage = GLBParser.e2StrPlain(RetMsgElement, "GBK");
            int start = retMessage.indexOf("<ret_info>");
            int end = retMessage.indexOf("</ret_info>", start);
            retMsg = retMessage.substring(start + "<retMessage>".length(), end);
        }
        rsp.setResponseCode(retCode);
        rsp.setResponseMessage(StringUtils.catWithSpace((String[])new String[]{retCode, retMsg}));
        return rsp;
    }

    private static String e2StrPlain(Element element, String encoding) {
        XMLOutputter outputter = new XMLOutputter();
        Format newFormat = Format.getPrettyFormat();
        newFormat.setEncoding(encoding);
        newFormat.setExpandEmptyElements(true);
        newFormat.setIndent("");
        newFormat.setLineSeparator("");
        outputter.setFormat(newFormat);
        return outputter.outputString(element).trim();
    }

    public static String[][] parseMFS(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allrecord[(i + 1) * fieldNum + j];
            }
        }
        return r2;
    }
}

