/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.balance;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseAccountQaccbalRequestV1;
import com.icbc.api.response.MybankEnterpriseAccountQaccbalResponseV1;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.opa.service.balance.BalanceParser;
import kd.ebg.aqap.banks.icbc.opa.service.util.GetStore;
import kd.ebg.aqap.banks.icbc.opa.service.util.TestDateUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import net.sf.json.JSONObject;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "QACCBAL";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]);
    }

    public EBBankBalanceResponse balance(BankBalanceRequest rqst) {
        String BASE_URL = GetStore.getBaseUrl();
        String URI = "mybank/enterprise/account/qaccbal/V1";
        DefaultIcbcClient client = GetStore.getClient();
        try {
            MybankEnterpriseAccountQaccbalRequestV1.MybankEnterpriseAccountQaccbalRequestBizV1 bizContent = new MybankEnterpriseAccountQaccbalRequestV1.MybankEnterpriseAccountQaccbalRequestBizV1();
            Date date = new Date();
            bizContent.setTransCode("QACCBAL");
            bizContent.setTranDate(TestDateUtil.getDate());
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqno(Sequence.gen18Sequence());
            bizContent.setTotalNum(Integer.valueOf(1));
            bizContent.setCis(RequestContextUtils.getBankParameterValue((String)"cis"));
            bizContent.setBankCode("102");
            String cer_name = RequestContextUtils.getBankParameterValue((String)"cer_name");
            bizContent.setLoginId(cer_name);
            BankAcnt acnt = rqst.getAcnt();
            ArrayList<MybankEnterpriseAccountQaccbalRequestV1.MybankEnterpriseAccountQaccbalRequestRdV1> rds = new ArrayList<MybankEnterpriseAccountQaccbalRequestV1.MybankEnterpriseAccountQaccbalRequestRdV1>();
            MybankEnterpriseAccountQaccbalRequestV1.MybankEnterpriseAccountQaccbalRequestRdV1 rd = new MybankEnterpriseAccountQaccbalRequestV1.MybankEnterpriseAccountQaccbalRequestRdV1();
            rd.setAccountNo(acnt.getAccNo());
            rd.setCurrency(rqst.getBankCurrency());
            rd.setiSeqno("1");
            rd.setBankType("102");
            rds.add(rd);
            bizContent.setRd(rds);
            MybankEnterpriseAccountQaccbalRequestV1 request = new MybankEnterpriseAccountQaccbalRequestV1();
            request.setServiceUrl(BASE_URL + URI);
            request.setBizContent((BizContent)bizContent);
            this.logger.info("\u4f59\u989d\u67e5\u8be2\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)request).toString());
            MybankEnterpriseAccountQaccbalResponseV1 response = (MybankEnterpriseAccountQaccbalResponseV1)client.execute((IcbcRequest)request, Sequence.gen18Sequence());
            this.logger.info("\u4f59\u989d\u67e5\u8be2\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
            return new BalanceParser().parseTodayBalance(rqst, response);
        }
        catch (Exception e) {
            this.logger.error("balance error :", (Throwable)e);
            String causeMsg = Objects.nonNull(e.getCause()) ? "||" + e.getCause().toString() : "";
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 %s\u3002", (String)"BalanceImpl_7", (String)"ebg-aqap-banks-icbcasia-dc", (Object[])new Object[0]), e.getMessage() + causeMsg));
        }
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return null;
    }
}

