/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.balancereconciliation;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.MybankEnterpriseReconctilationYdzqrybalRequestV1;
import com.icbc.api.response.MybankEnterpriseReconctilationYdzqrybalResponseV1;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.opa.service.util.GetStore;
import kd.ebg.aqap.banks.icbc.opa.service.util.TestDateUtil;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceStatementImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceStatement;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceStatementRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceStatementResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import net.sf.json.JSONObject;

public class BalanceStatementImpl
extends AbstractBalanceStatementImpl
implements IBalanceStatement {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceStatementImpl.class);

    public int getMonthSpan() {
        return 6;
    }

    public EBBankBalanceStatementResponse doBiz(BankBalanceStatementRequest request) {
        String BASE_URL = GetStore.getBaseUrl();
        String URI = "mybank/enterprise/reconctilation/ydzqrybal/V1";
        DefaultIcbcClient client = GetStore.getClient();
        try {
            MybankEnterpriseReconctilationYdzqrybalRequestV1.MybankEnterpriseReconctilationYdzqrybalRequestBizV1 bizContent = new MybankEnterpriseReconctilationYdzqrybalRequestV1.MybankEnterpriseReconctilationYdzqrybalRequestBizV1();
            MybankEnterpriseReconctilationYdzqrybalRequestV1 icbcRequest = new MybankEnterpriseReconctilationYdzqrybalRequestV1();
            Date date = new Date();
            bizContent.setTransCode("YDZQRYBAL");
            bizContent.setTranDate(TestDateUtil.getDate());
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setLanguage("zh_CN");
            bizContent.setfSeqNo(Sequence.gen18Sequence());
            LocalDate start = LocalDate.parse(request.getStartMonth() + "01", DateTimeFormatter.ofPattern("yyyyMMdd"));
            LocalDate end = YearMonth.parse(request.getEndMonth(), DateTimeFormatter.ofPattern("yyyyMM")).atEndOfMonth();
            bizContent.setBeginDate(start.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            bizContent.setEndDate(end.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            bizContent.setAccNo(request.getAccNo());
            icbcRequest.setServiceUrl(BASE_URL + URI);
            icbcRequest.setBizContent((BizContent)bizContent);
            this.logger.info("\u4f59\u989d\u5bf9\u8d26\u67e5\u8be2\u5f85\u7ecf\u529e\u8bb0\u5f55\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)icbcRequest).toString());
            MybankEnterpriseReconctilationYdzqrybalResponseV1 response = (MybankEnterpriseReconctilationYdzqrybalResponseV1)client.execute((IcbcRequest)icbcRequest);
            ArrayList<BalanceReconciliationDetail> detailList = new ArrayList<BalanceReconciliationDetail>(10);
            if (response.isSuccess()) {
                List rd = response.getRd();
                for (MybankEnterpriseReconctilationYdzqrybalResponseV1.MybankEnterpriseReconctilationYdzqrybalResponseRdV1 v1 : rd) {
                    String accNo = v1.getAccNo();
                    String dzdNo = v1.getDzdNo();
                    String dzFlag = v1.getDzFlag();
                    this.logger.info("\u89e3\u6790\u5f85\u7ecf\u529e\u8bb0\u5f55:\n" + JSONObject.fromObject((Object)v1).toString());
                    if (!dzFlag.equalsIgnoreCase("3")) continue;
                    String currCode = v1.getCurrCode();
                    Long balance = v1.getBalance();
                    String dzDate = v1.getdZGenDate();
                    BalanceReconciliationDetail detail = new BalanceReconciliationDetail();
                    detail.setAccNo(accNo);
                    detail.setCurrency(currCode);
                    detail.setMonth(dzDate.substring(0, 6));
                    BigDecimal bigDecimal = new BigDecimal(balance);
                    detail.setBalance(bigDecimal.divide(new BigDecimal("100")).toPlainString());
                    detail.setStatementNo(dzdNo);
                    detailList.add(detail);
                }
                return new EBBankBalanceStatementResponse(detailList);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 \u7f51\u5173\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%2$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%3$s\u3002", (String)"BalanceParser_6", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]), response.getReturnMsg(), response.getReturnCode(), response.getReturnMsg()));
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(BankBalanceStatementRequest bankBalanceStatementRequest) {
        return null;
    }

    public EBBankBalanceStatementResponse parse(BankBalanceStatementRequest bankBalanceStatementRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "YDZQRYBAL";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u5e10\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u3002", (String)"BalanceStatementImpl_0", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceStatementRequest bankBalanceStatementRequest) {
        return true;
    }
}

