/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.financing.buy;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.InvestmentEnterpriseFinancialPbuyadvsubmitRequestV1;
import com.icbc.api.response.InvestmentEnterpriseFinancialPbuyadvsubmitResponseV1;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.opa.service.util.GetStore;
import kd.ebg.aqap.banks.icbc.opa.service.util.PackerUtils;
import kd.ebg.aqap.banks.icbc.opa.service.util.TestDateUtil;
import kd.ebg.aqap.business.financing.atomic.AbstractFinancingImpl;
import kd.ebg.aqap.business.financing.atomic.IBuyFinancing;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.financing.bank.EBBankFinancingResponse;
import kd.ebg.aqap.business.financing.util.FinancingUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import net.sf.json.JSONObject;

public class BuyFinancingImpl
extends AbstractFinancingImpl
implements IBuyFinancing {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BuyFinancingImpl.class);

    public EBBankFinancingResponse buyFinancing(BankFinancingRequest request) {
        List fInfos = request.getInfos();
        if (fInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5355\u7b14\u7406\u8d22\u3002", (String)"BuyFinancingImpl_0", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
        }
        FinancingInfo fInfo = (FinancingInfo)fInfos.get(0);
        String BASE_URL = GetStore.getBaseUrl();
        String URI = "investment/enterprise/financial/pbuyadvsubmit/V1";
        DefaultIcbcClient client = GetStore.getClient();
        try {
            InvestmentEnterpriseFinancialPbuyadvsubmitRequestV1.InvestmentEnterpriseFinancialPbuyadvsubmitRequestBizV1 bizContent = new InvestmentEnterpriseFinancialPbuyadvsubmitRequestV1.InvestmentEnterpriseFinancialPbuyadvsubmitRequestBizV1();
            InvestmentEnterpriseFinancialPbuyadvsubmitRequestV1 req = new InvestmentEnterpriseFinancialPbuyadvsubmitRequestV1();
            req.setBizContent((BizContent)bizContent);
            req.setServiceUrl(BASE_URL + URI);
            Date date = new Date();
            bizContent.setTransCode("PBUYADV");
            bizContent.setTranDate(TestDateUtil.getDate());
            bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
            bizContent.setfSeqNo(request.getBatchSeqId());
            bizContent.setTotalNumber(Integer.valueOf(1));
            bizContent.setTotalAmount(Long.valueOf(PackerUtils.getAmount(fInfo).longValue()));
            bizContent.setAccountNo(fInfo.getAccNo());
            ArrayList<InvestmentEnterpriseFinancialPbuyadvsubmitRequestV1.InvestmentEnterpriseFinancialPbuyadvsubmitRequestRdV1> rds = new ArrayList<InvestmentEnterpriseFinancialPbuyadvsubmitRequestV1.InvestmentEnterpriseFinancialPbuyadvsubmitRequestRdV1>(1);
            InvestmentEnterpriseFinancialPbuyadvsubmitRequestV1.InvestmentEnterpriseFinancialPbuyadvsubmitRequestRdV1 rd = new InvestmentEnterpriseFinancialPbuyadvsubmitRequestV1.InvestmentEnterpriseFinancialPbuyadvsubmitRequestRdV1();
            rd.setAmount(Long.valueOf(PackerUtils.getAmount(fInfo).longValue()));
            rd.setiSeqNo(fInfo.getDetailSeqID());
            rd.setProductCode(fInfo.getProductCode());
            rd.setRollFlag("2");
            rd.setErpSeq(fInfo.getDetailBizNo());
            rd.setRollDate(Integer.valueOf(Integer.parseInt(fInfo.getRollDate())));
            rds.add(rd);
            bizContent.setRd(rds);
            logger.info("\u7406\u8d22\u4ea7\u54c1\u8d2d\u4e70\u6307\u4ee4\u63d0\u4ea4\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)req).toString());
            InvestmentEnterpriseFinancialPbuyadvsubmitResponseV1 response = (InvestmentEnterpriseFinancialPbuyadvsubmitResponseV1)client.execute((IcbcRequest)req, Sequence.gen18Sequence());
            logger.info("\u7406\u8d22\u4ea7\u54c1\u8d2d\u4e70\u6307\u4ee4\u63d0\u4ea4\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)response).toString());
            if (response.isSuccess()) {
                FinancingUtil.setState((FinancingInfo)fInfo, (FinancingState)FinancingState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BuyFinancingImpl_1", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]), (String)response.getReturnMsg(), (String)"");
            } else {
                FinancingUtil.setState((FinancingInfo)fInfo, (FinancingState)FinancingState.UNKNOWN, (String)"", (String)response.getReturnMsg(), (String)"");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error(e.getCause().toString());
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        EBBankFinancingResponse ebBankFinancingResponse = new EBBankFinancingResponse();
        ebBankFinancingResponse.setInfos(fInfos);
        return ebBankFinancingResponse;
    }

    public String pack(BankFinancingRequest bankFinancingRequest) {
        return null;
    }

    public EBBankFinancingResponse parse(BankFinancingRequest bankFinancingRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return "cw";
    }

    public String getBizCode() {
        return "PBUYADV";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7406\u8d22\u4ea7\u54c1\u8d2d\u4e70\u6307\u4ee4\u63d0\u4ea4\u3002", (String)"BuyFinancingImpl_2", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]);
    }

    public boolean match(BankFinancingRequest bankFinancingRequest) {
        return false;
    }
}

