/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.financing.buy;

import com.icbc.api.BizContent;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.request.InvestmentEnterpriseFinancialQhggdetqryRequestV1;
import com.icbc.api.request.InvestmentEnterpriseFinancialQpbuyadvqryRequestV1;
import com.icbc.api.response.InvestmentEnterpriseFinancialQhggdetqryResponseV1;
import com.icbc.api.response.InvestmentEnterpriseFinancialQpbuyadvqryResponseV1;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.opa.service.util.GetStore;
import kd.ebg.aqap.banks.icbc.opa.service.util.PackerUtils;
import kd.ebg.aqap.banks.icbc.opa.service.util.TestDateUtil;
import kd.ebg.aqap.business.financing.atomic.AbstractFinancingImpl;
import kd.ebg.aqap.business.financing.atomic.IQueryBuyFinancing;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.financing.bank.EBBankFinancingResponse;
import kd.ebg.aqap.business.financing.util.FinancingUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import net.sf.json.JSONObject;

public class QryBuyFinancingImpl
extends AbstractFinancingImpl
implements IQueryBuyFinancing {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QryBuyFinancingImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EBBankFinancingResponse queryBuyFinancing(BankFinancingRequest request) {
        List fInfos;
        block8: {
            fInfos = request.getInfos();
            FinancingInfo fInfo = (FinancingInfo)fInfos.get(0);
            String BASE_URL = GetStore.getBaseUrl();
            String URI = "investment/enterprise/financial/qpbuyadvqry/V1";
            DefaultIcbcClient client = GetStore.getClient();
            try {
                InvestmentEnterpriseFinancialQpbuyadvqryRequestV1.InvestmentEnterpriseFinancialQpbuyadvqryRequestBizV1 bizContent = new InvestmentEnterpriseFinancialQpbuyadvqryRequestV1.InvestmentEnterpriseFinancialQpbuyadvqryRequestBizV1();
                InvestmentEnterpriseFinancialQpbuyadvqryRequestV1 reqV1 = new InvestmentEnterpriseFinancialQpbuyadvqryRequestV1();
                bizContent.setTransCode("QPBUYADV");
                Date date = new Date();
                bizContent.setTranDate(TestDateUtil.getDate());
                bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
                bizContent.setfSeqNo(Sequence.gen14Sequence());
                bizContent.setQryfSeqNo(fInfo.getBatchSeqId());
                reqV1.setBizContent((BizContent)bizContent);
                reqV1.setServiceUrl(BASE_URL + URI);
                logger.info("\u7406\u8d22\u4ea7\u54c1\u8d2d\u4e70\u6307\u4ee4\u67e5\u8be2\u94f6\u884c\u8bf7\u6c42\u53c2\u6570:\n" + JSONObject.fromObject((Object)reqV1).toString());
                InvestmentEnterpriseFinancialQpbuyadvqryResponseV1 resp = (InvestmentEnterpriseFinancialQpbuyadvqryResponseV1)client.execute((IcbcRequest)reqV1);
                logger.info("\u7406\u8d22\u4ea7\u54c1\u8d2d\u4e70\u6307\u4ee4\u67e5\u8be2\u94f6\u884c\u8fd4\u56de\u53c2\u6570:\n" + JSONObject.fromObject((Object)resp).toString());
                if (!resp.isSuccess()) break block8;
                List rds = resp.getRd();
                InvestmentEnterpriseFinancialQpbuyadvqryResponseV1.InvestmentEnterpriseFinancialQpbuyadvqryResponseRdV1 rd = (InvestmentEnterpriseFinancialQpbuyadvqryResponseV1.InvestmentEnterpriseFinancialQpbuyadvqryResponseRdV1)rds.get(0);
                if (!rd.getiSeqNo().equalsIgnoreCase(fInfo.getDetailBizNo())) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4fe1\u606f\u4e0e\u671f\u671b\u4e0d\u7b26\u3002", (String)"QryBuyFinancingImpl_0", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]));
                }
                String result = rd.getResult();
                if (!PackerUtils.staMap.containsKey(result)) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u7ed3\u679c\u7801%s\u3002", (String)"QryBuyFinancingImpl_4", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]), result));
                }
                if ("7".equalsIgnoreCase(result)) {
                    FinancingUtil.setState((FinancingInfo)fInfo, (FinancingState)FinancingState.SUCCESS, (String)"", (String)result, (String)rd.getiReturnMsg());
                    URI = "investment/enterprise/financial/qhggdetqry/V1";
                    InvestmentEnterpriseFinancialQhggdetqryRequestV1.InvestmentEnterpriseFinancialQhggdetqryRequestBizV1 bizContent2 = new InvestmentEnterpriseFinancialQhggdetqryRequestV1.InvestmentEnterpriseFinancialQhggdetqryRequestBizV1();
                    InvestmentEnterpriseFinancialQhggdetqryRequestV1 req2V1 = new InvestmentEnterpriseFinancialQhggdetqryRequestV1();
                    bizContent2.setTransCode("QHGGDET");
                    bizContent2.setTranDate(TestDateUtil.getDate());
                    bizContent2.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
                    bizContent2.setfSeqNo(Sequence.genSequence());
                    bizContent2.setAccountNo(fInfo.getAccNo());
                    bizContent2.setAccountName(fInfo.getAccName());
                    bizContent2.setProductCode(fInfo.getProductCode());
                    bizContent2.setErpSeq(fInfo.getDetailBizNo());
                    bizContent2.setQueryType("0");
                    bizContent2.setBeginDate(fInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                    bizContent2.setEndDate(fInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                    bizContent2.setNextTag("");
                    req2V1.setBizContent((BizContent)bizContent2);
                    req2V1.setServiceUrl(BASE_URL + URI);
                    InvestmentEnterpriseFinancialQhggdetqryResponseV1 IEFQR = (InvestmentEnterpriseFinancialQhggdetqryResponseV1)client.execute((IcbcRequest)req2V1);
                    if (!IEFQR.isSuccess()) {
                        logger.error(IEFQR.getReturnMsg());
                        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7406\u8d22\u660e\u7ec6\u51fa\u73b0\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de%s\u3002", (String)"QryBuyFinancingImpl_6", (String)"ebg-aqap-banks-icbc-opa", (Object[])new Object[0]), IEFQR.getReturnMsg()));
                    }
                    List rdss = IEFQR.getRd();
                    rdss = rdss.stream().filter(e -> e.getProductCode().equalsIgnoreCase(fInfo.getProductCode())).collect(Collectors.toList());
                    InvestmentEnterpriseFinancialQhggdetqryResponseV1.InvestmentEnterpriseFinancialQhggdetqryResponseRdV1 ie = (InvestmentEnterpriseFinancialQhggdetqryResponseV1.InvestmentEnterpriseFinancialQhggdetqryResponseRdV1)rdss.get(0);
                    String productName = ie.getProductName();
                    String busiType = ie.getBusiType();
                    String price = ie.getPrice();
                    String exchQuota = ie.getExchQuota();
                    Long exchAmount = ie.getExchAmount();
                    fInfo.setProductName(productName);
                    BigDecimal eQ = new BigDecimal(price);
                    eQ = eQ.divide(new BigDecimal("1000000"), 5, 1);
                    fInfo.setPrice(eQ.toString());
                    fInfo.setFinancingType(busiType);
                    fInfo.setNumber(exchQuota);
                    BigDecimal eA = new BigDecimal(exchAmount);
                    eA = eA.divide(PackerUtils.ONE_HUNDRED, 5, 1);
                    fInfo.setAmount(eA.toString());
                    break block8;
                }
                if ("0".equalsIgnoreCase(result) || "1".equalsIgnoreCase(result) || "2".equalsIgnoreCase(result) || "3".equalsIgnoreCase(result) || "4".equalsIgnoreCase(result) || "9".equalsIgnoreCase(result)) {
                    FinancingUtil.setState((FinancingInfo)fInfo, (FinancingState)FinancingState.SUBMITED, (String)PackerUtils.staMap.get(result), (String)result, (String)rd.getiReturnMsg());
                } else {
                    FinancingUtil.setState((FinancingInfo)fInfo, (FinancingState)FinancingState.FAIL, (String)PackerUtils.staMap.get(result), (String)result, (String)rd.getiReturnMsg());
                }
            }
            catch (Exception e2) {
                logger.error(e2.getMessage());
                logger.error(e2.getCause().toString());
                throw EBExceiptionUtil.serviceException((Throwable)e2);
            }
        }
        EBBankFinancingResponse ebBankFinancingResponse = new EBBankFinancingResponse();
        ebBankFinancingResponse.setInfos(fInfos);
        return ebBankFinancingResponse;
    }

    public String pack(BankFinancingRequest bankFinancingRequest) {
        return null;
    }

    public EBBankFinancingResponse parse(BankFinancingRequest bankFinancingRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(BankFinancingRequest bankFinancingRequest) {
        return false;
    }
}

