/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.opa.service.payment.oversea;

import com.icbc.api.request.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.ebg.aqap.banks.icbc.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.opa.service.util.PackerUtils;
import kd.ebg.aqap.banks.icbc.opa.service.util.TestDateUtil;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.framework.services.BankAcntOpService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PayPacker {
    public static MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestBizV1 pack(List<PaymentInfo> paymentInfos) {
        MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestBizV1 bizContent = new MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestBizV1();
        bizContent.setTransCode("GLOBALPAY");
        Date date = new Date();
        bizContent.setTranDate(TestDateUtil.getDate());
        bizContent.setTranTime(DateTimeUtils.format((Date)date, (String)"HHmmssSSS"));
        bizContent.setLanguage("zh_CN");
        bizContent.setfSeqNo(paymentInfos.get(0).getBankBatchSeqID());
        bizContent.setTotalNum(Integer.valueOf(paymentInfos.size()));
        bizContent.setTotalAmt(PackerUtils.getTotalAmountLong(paymentInfos));
        ArrayList<MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestRdV1> lists = new ArrayList<MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestRdV1>(16);
        for (PaymentInfo paymentInfo : paymentInfos) {
            MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestRdV1 rd = new MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestV1.MybankOspayEnterpriseGlobalcashmanagementMoegglobalpaysubmitRequestRdV1();
            boolean foreignAccNo = BankAcntOpService.getInstance().isForeignAccNo(paymentInfo.getAccNo());
            rd.setUniBusiId(paymentInfo.getBankDetailSeqID());
            rd.setiSeqNo(paymentInfo.getBankSerialNo());
            rd.setSettleMode("0");
            rd.setPayerAccountNo(paymentInfo.getAccNo());
            if (!foreignAccNo) {
                rd.setPayerAccountName(paymentInfo.getAccName());
            }
            rd.setPayerEnAccountName(paymentInfo.getAccName());
            rd.setPayerAccountType("1");
            if (foreignAccNo) {
                rd.setPayerBankBic(BankBusinessConfig.getBicCode(paymentInfo.getAccNo()));
            }
            if (paymentInfo.isDiffCurrency()) {
                rd.setCurrency(paymentInfo.getExchangeCurrency());
            } else {
                rd.setCurrency(paymentInfo.getCurrency());
            }
            rd.setAmount(PackerUtils.getAmountLong(paymentInfo));
            rd.setPayeeCurrency(paymentInfo.getPayCurrency());
            if (paymentInfo.is2SameBank()) {
                rd.setSysIoFlag("1");
            } else {
                rd.setSysIoFlag("2");
            }
            rd.setPayeeAccountName(paymentInfo.getIncomeAccName());
            rd.setPayeeAccountNo(paymentInfo.getIncomeAccNo());
            rd.setPayeeAccountType("1");
            rd.setPayeeAddress(paymentInfo.getIncomeAddress());
            rd.setPayeeBankName(paymentInfo.getIncomeBankName());
            if (!foreignAccNo) {
                rd.setPayeeBankCode("");
            }
            rd.setPayeeBankBic(paymentInfo.getIncomeSwiftCode());
            rd.setPayeePhone(paymentInfo.getMobiles());
            CountryISOCode incomeIsoCode = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getIncomeCountry());
            if (incomeIsoCode == null) {
                incomeIsoCode = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
            }
            rd.setPayeeCountry(incomeIsoCode.geteChart2());
            if (!foreignAccNo && paymentInfo.isDiffCurrency()) {
                rd.setContractNo(paymentInfo.getContractNo());
                rd.setBsFlag(paymentInfo.isBondGoodsFlag() ? "1" : "0");
                rd.setPayProperty(paymentInfo.getPayProperty());
                rd.setBusyType("06");
            }
            if (foreignAccNo) {
                rd.setRemark(paymentInfo.getExplanation());
                rd.setBusType("");
                if (StringUtils.isNotEmpty((String)paymentInfo.getBeneEmail())) {
                    rd.setPayeeEmailAddress(paymentInfo.getBeneEmail().replaceAll(";", "\\\\|"));
                }
            }
            rd.setTransPostScripts(paymentInfo.getExplanation());
            rd.setErpSeqno(paymentInfo.getBankDetailSeqID());
            String summary = paymentInfo.getExplanation();
            if (!StringUtils.isEmpty((String)summary) && summary.length() > 20) {
                summary = summary.substring(0, 20);
            }
            rd.setSummary(summary);
            rd.setPurpose(summary);
            String feeMode = "OUR";
            if ("02".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
                feeMode = "BEN";
            } else if ("03".equalsIgnoreCase(paymentInfo.getPayerFeeType())) {
                feeMode = "SHA";
            }
            rd.setFeePayer(feeMode);
            if (paymentInfo.getBookingTime() != null && !paymentInfo.getBookingTime().toLocalDate().isBefore(LocalDate.now())) {
                rd.setAppointmentDate(paymentInfo.getBookingTime().toLocalDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                PaymentUtil.setBookPayFlag((PaymentInfo)paymentInfo);
            }
            lists.add(rd);
        }
        bizContent.setRd(lists);
        return bizContent;
    }
}

