/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jxnx.dc.services.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jxnx.dc.services.Parser;
import kd.ebg.aqap.banks.jxnx.dc.util.FactoryUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        return FactoryUtil.setFactory(factory, "B2EActBalQry");
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element root = JDomUtils.createRoot((String)"Message");
        Element head = JDomUtils.addChild((Element)root, (String)"Head");
        JDomUtils.addChild((Element)head, (String)"TrsCode", (String)"B2EActBalQry");
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        Element list = JDomUtils.addChild((Element)body, (String)"List");
        Element map = JDomUtils.addChild((Element)list, (String)"Map");
        JDomUtils.addChild((Element)map, (String)"AcNo", (String)bankBalanceRequest.getAcnt().getAccNo());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseHeader(root);
        if (!"000000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%1$s, %2$s", (String)"BalanceImpl_8", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element body = root.getChild("Body");
        Element list = body.getChild("List");
        List maps = list.getChildren("Map");
        if (null == maps || maps.size() == 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e0d\u6b63\u786e\uff1a<Map>\u8282\u70b9\u4e3a\u7a7a.", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]));
        }
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(maps.size());
        for (Element map : maps) {
            String returnCode = map.getChildTextTrim("ReturnCode");
            String returnMsg = map.getChildTextTrim("ReturnMsg");
            String acNo = map.getChildTextTrim("AcNo");
            if (!"000000".equals(returnCode)) {
                throw EBExceiptionUtil.serviceException((String)(String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%1$s %2$s;", (String)"BalanceImpl_9", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]), returnCode, returnMsg) + "\n" + String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u662f:%s", (String)"BalanceImpl_10", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]), acNo)));
            }
            String currency = map.getChildTextTrim("Currency");
            String bal = map.getChildTextTrim("Balance");
            String availBal = map.getChildTextTrim("AvailBal");
            logger.info("\u6c5f\u82cf\u519c\u4fe1\u793e\u8fd4\u56de\u7684'\u8d26\u53f7'\u4e3a" + acNo);
            logger.info("\u6c5f\u82cf\u519c\u4fe1\u793e\u8fd4\u56de\u7684'\u5e01\u79cd'\u4e3a" + currency);
            logger.info("\u6c5f\u82cf\u519c\u4fe1\u793e\u8fd4\u56de\u7684'\u5f53\u524d\u4f59\u989d'\u4e3a" + bal + "\u5143");
            logger.info("\u6c5f\u82cf\u519c\u4fe1\u793e\u8fd4\u56de\u7684'\u53ef\u7528\u4f59\u989d'\u4e3a" + availBal + "\u5143");
            if (!bankBalanceRequest.getAcnt().getAccNo().equals(acNo)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u6570\u636e\u9519\u8bef\uff1a\u8d26\u53f7[%1$s]\u4e0e\u67e5\u8be2\u8d26\u53f7[%2$s]\u4e0d\u7b26\u3002", (String)"BalanceImpl_11", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]), acNo, bankBalanceRequest.getAcnt().getAccNo()));
            }
            BalanceInfo balanceInfo = new BalanceInfo();
            balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
            if (StringUtils.isEmpty((String)bal)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"BalanceImpl_6", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]));
            }
            balanceInfo.setCurrentBalance(new BigDecimal(bal));
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            balanceInfo.setBankCurrency(currency);
            if (!StringUtils.isEmpty((String)availBal)) {
                balanceInfo.setAvailableBalance(new BigDecimal(availBal));
            }
            balanceInfos.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"BalanceImpl_7", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]);
    }
}

