/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jxnx.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jxnx.dc.services.Parser;
import kd.ebg.aqap.banks.jxnx.dc.util.FactoryUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        return FactoryUtil.setFactory(factory, "B2EActTrsQry");
    }

    public boolean isSupportPage() {
        return true;
    }

    public String pack(BankDetailRequest rqst) {
        Element root = JDomUtils.createRoot((String)"Message");
        Element head = JDomUtils.addChild((Element)root, (String)"Head");
        JDomUtils.addChild((Element)head, (String)"TrsCode", (String)"B2EActTrsQry");
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        Element list = JDomUtils.addChild((Element)body, (String)"List");
        Element map = JDomUtils.addChild((Element)list, (String)"Map");
        JDomUtils.addChild((Element)map, (String)"AcNo", (String)rqst.getAcnt().getAccNo());
        JDomUtils.addChild((Element)map, (String)"BeginDate", (String)rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)map, (String)"EndDate", (String)rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)map, (String)"startPatches", (String)this.getPageTag());
        JDomUtils.addChild((Element)map, (String)"requestPatches", (String)"10");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    String getPageTag() {
        String pageTag = this.getCurrentPage();
        if ("0".equals(pageTag)) {
            pageTag = "1";
        }
        return pageTag;
    }

    public EBBankDetailResponse parse(BankDetailRequest rqst, String s) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(3);
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseHeader(root);
        if (!"000000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%1$s\uff0c%2$s\u3002", (String)"DetailImpl_8", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element body = root.getChild("Body");
        Element list = body.getChild("List");
        Element map = list.getChild("Map");
        String returnCode = map.getChildTextTrim("ReturnCode");
        String returnMsg = map.getChildTextTrim("ReturnMsg");
        if (!"000000".equals(returnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%1$s\uff0c%2$s\u3002", (String)"DetailImpl_8", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]), returnCode, returnMsg));
        }
        String acNo = map.getChildTextTrim("AcNo");
        if (!rqst.getAcnt().getAccNo().equals(acNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a\u94f6\u884c\u8fd4\u56de\u7684\u8d26\u53f7[%1$s]\u4e0e\u8bf7\u6c42\u8d26\u53f7[%2$s]\u4e0d\u7b26\u3002", (String)"DetailImpl_9", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]), acNo, rqst.getAcnt().getAccNo()));
        }
        Element list2 = map.getChild("List");
        List map2s = list2.getChildren("Map");
        if (null == map2s || map2s.isEmpty()) {
            this.setLastPage(true);
            return new EBBankDetailResponse(detailList);
        }
        int apgeSize = Integer.parseInt("10");
        if (map2s.size() < apgeSize) {
            this.setLastPage(true);
        }
        this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + apgeSize);
        for (int i = 0; i < map2s.size(); ++i) {
            LocalDateTime transDateTime;
            Element map2 = (Element)map2s.get(i);
            String transDate = map2.getChildTextTrim("TransDate");
            String transTime = map2.getChildTextTrim("TransTime");
            String currency = map2.getChildTextTrim("Currency");
            String cRFlag = map2.getChildTextTrim("CRFlag");
            String dCFlag = map2.getChildTextTrim("DCFlag");
            String amount = map2.getChildTextTrim("Amount");
            String bal = map2.getChildTextTrim("Balance");
            String remark = map2.getChildTextTrim("Remark");
            String otherAcNo = map2.getChildTextTrim("OtherAcNo");
            String otherName = map2.getChildTextTrim("OtherName");
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(rqst.getAcnt().getAccNo());
            detail.setAccName(rqst.getAcnt().getAccName());
            detail.setBankName(rqst.getAcnt().getBankName());
            detail.setCurrency(currency);
            if ("D".equals(dCFlag)) {
                detail.setDebitAmount(new BigDecimal(amount));
                detail.setCreditAmount(Parser.ZERO);
            } else if ("C".equals(dCFlag)) {
                detail.setDebitAmount(Parser.ZERO);
                detail.setCreditAmount(new BigDecimal(amount));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7DCFlag=%s\u3002", (String)"DetailImpl_10", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]), dCFlag));
            }
            detail.setOppAccNo(otherAcNo);
            detail.setOppAccName(otherName);
            detail.setExplanation(remark);
            if (!StringUtils.isEmpty((String)transDate)) {
                try {
                    if (StringUtils.isEmpty((String)transTime)) {
                        transDateTime = LocalDateTime.parse(transDate + "00.00.00", DateTimeFormatter.ofPattern("yyyy-MM-ddHH.mm.ss"));
                    }
                    transDateTime = LocalDateTime.parse(transDate + transTime, DateTimeFormatter.ofPattern("yyyy-MM-ddHH.mm.ss"));
                }
                catch (Exception e) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38%s\u3002", (String)"DetailImpl_11", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                }
            } else {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f<TransDate>\u8282\u70b9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5b8c\u6210\u94f6\u884c\u4ea4\u6613\u3002", (String)"DetailImpl_6", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]));
            }
            detail.setTransTime(transDateTime);
            detail.setTransDate(transDateTime.toLocalDate());
            if (!StringUtils.isEmpty((String)bal)) {
                detail.setBalance(new BigDecimal(bal));
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(map2);
            detail.setJsonMap(jsonStr);
            detailList.add(detail);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"DetailImpl_7", (String)"ebg-aqap-banks-jsnx-dc", (Object[])new Object[0]);
    }
}

