/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scnx.dc.services.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scnx.dc.services.utils.CommonPacker;
import kd.ebg.aqap.banks.scnx.dc.services.utils.CommonParser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml;charset=" + RequestContextUtils.getCharset());
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"exchangeUri"));
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        Element root = CommonPacker.packHeader(this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"BODY");
        JDomUtils.addChild((Element)body, (String)"TX_ACCT_NO", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"CUR_CD", (String)bankBalanceRequest.getBankCurrency());
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse response = CommonParser.parserHead(root);
        if (!"000000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff0c\u62a5\u6587\u8fd4\u56de\u72b6\u6001\uff1a%1$s\uff0c\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\uff1a%2$s\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-scnx-dc", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element body = root.getChild("BODY");
        String acc_no = body.getChildText("TX_ACCT_NO");
        String currency = body.getChildText("CUR_CD");
        String currentBalance = body.getChildText("CURR_BAL");
        String availableBalance = body.getChildText("AVAL_BAL");
        if (!bankBalanceRequest.getAcnt().getAccNo().equals(acc_no)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u8d26\u53f7\u4e0e\u8bf7\u6c42\u8d26\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-scnx-dc", (Object[])new Object[0]));
        }
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfos.add(balanceInfo);
        balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
        balanceInfo.setBankCurrency(currency);
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        if (StringUtils.isNotEmpty((String)currentBalance)) {
            balanceInfo.setCurrentBalance(new BigDecimal(currentBalance));
        }
        if (StringUtils.isNotEmpty((String)availableBalance)) {
            balanceInfo.setAvailableBalance(new BigDecimal(availableBalance));
        }
        EBBankBalanceResponse rsp = new EBBankBalanceResponse();
        rsp.setBalances(balanceInfos);
        return rsp;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "TC001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d", (String)"BalanceImpl_3", (String)"ebg-aqap-banks-scnx-dc", (Object[])new Object[0]);
    }
}

