/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scnx.dc.services.payment.allocation;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scnx.dc.SCNXDCMetaDataImpl;
import kd.ebg.aqap.banks.scnx.dc.services.payment.CommonPayParser;
import kd.ebg.aqap.banks.scnx.dc.services.payment.allocation.AllocationQueryPaymentImpl;
import kd.ebg.aqap.banks.scnx.dc.services.utils.CommonPacker;
import kd.ebg.aqap.banks.scnx.dc.services.utils.ScnxConstants;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocationPaymentImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml;charset=" + RequestContextUtils.getCharset());
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"exchangeUri"));
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AllocationQueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = CommonPacker.packHeader(this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"BODY");
        JDomUtils.addChild((Element)body, (String)"APRPTTYPCD", (String)ScnxConstants.ALLOCATION_CODE_MAP.get(paymentInfo.getUseCn()));
        JDomUtils.addChild((Element)body, (String)"PAY_PTY_ACCT_NO", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PAY_PTY_ACCT_NM", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"RCV_PTY_ACCT_NO", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"RCV_PTY_ACCT_NM", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"CUR_CD", (String)"");
        JDomUtils.addChild((Element)body, (String)"APRPTAMT", (String)paymentInfo.getAmount().toString());
        JDomUtils.addChild((Element)body, (String)"USAGEDESCR", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"REMRK", (String)"");
        JDomUtils.addChild((Element)body, (String)"BIZFLOW", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)body, (String)"GRPPRNTCORPCUSTNO", (String)RequestContextUtils.getBankParameterValue((String)SCNXDCMetaDataImpl.custom_no));
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        new CommonPayParser().parsePay(request, responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "TC011";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5212\u62e8", (String)"AllocationPaymentImpl_0", (String)"ebg-aqap-banks-scnx-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType());
    }
}

