/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fjnxs.dc.services.payment.salary;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fjnxs.dc.utils.EBUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class B2EAgentQry
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 200;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element ebank_root = new Element("Message");
        String enterpriseCode = EBUtils.getExclusiveCifNo(paymentInfo.getAccNo());
        JDomUtils.addChild((Element)ebank_root, (Element)EBUtils.buildPackerHead(this.getBizCode(), Sequence.gen18Sequence()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        Element List2 = JDomUtils.addChild((Element)body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
        JDomUtils.addChild((Element)Map2, (String)"CifSeq", (String)enterpriseCode);
        String date = paymentInfo.getSubmitSuccessTime().format(EBUtils.dateTimeFormatter);
        JDomUtils.addChild((Element)Map2, (String)"BeginDate", (String)date);
        JDomUtils.addChild((Element)Map2, (String)"EndDate", (String)date);
        JDomUtils.addChild((Element)Map2, (String)"AgentFundNo", (String)"001");
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element bank_root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element body = bank_root.getChild("Body");
        BankResponse headRsp = EBUtils.parserResponseInfo(bank_root);
        String bankStatus = headRsp.getResponseCode();
        if (!"000000".equals(bankStatus)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u5931\u8d25 :%s", (String)"B2EAgentQry_0", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]), headRsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element list = body.getChild("List");
        List lists = list.getChildren("Map");
        if (!lists.isEmpty()) {
            String batchNO = paymentInfo.getBankRefID();
            if ((lists = lists.stream().filter(e -> e.getChildTextTrim("BatchNo").equalsIgnoreCase(batchNO)).collect(Collectors.toList())).size() == 1) {
                Element element = (Element)lists.get(0);
                String agentState = JDomUtils.getChildText((Element)element, (String)"AgentState");
                String transDate = JDomUtils.getChildText((Element)element, (String)"TransDate");
                String transTime = JDomUtils.getChildText((Element)element, (String)"TransTime");
                if ("2".equals(agentState)) {
                    PaymentInfoSysFiled.set((List)paymentInfos, (String)"TransDate", (String)transDate);
                    PaymentInfoSysFiled.set((List)paymentInfos, (String)"TransTime", (String)transTime);
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)agentState, (String)ResManager.loadKDString((String)"\u5904\u7406\u5b8c\u6210", (String)"B2EAgentQry_1", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]));
                    RequestContextUtils.setRunningParam((String)"FJNXS", (String)"true");
                } else if ("1".equals(agentState)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)agentState, (String)ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406", (String)"B2EAgentQry_2", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]));
                }
            } else {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001\u54cd\u5e94\u7684\u4fe1\u606f\u6709\u8bef\uff0c\u7b5b\u9009\u5230%s\u6761\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\uff01", (String)"B2EAgentQry_3", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]), lists.size());
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)errorMsg, (String)"", (String)"");
            }
        } else {
            String errorMsg = ResManager.loadKDString((String)"\u672a\u8fd4\u56de\u67e5\u8be2\u7684\u4ed8\u6b3e\u72b6\u6001\u4fe1\u606f\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\uff01", (String)"B2EAgentQry_4", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]);
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)errorMsg, (String)"", (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EAgentQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8fde\u8d22\u52a1\u7ba1\u7406\u67e5\u8be2\uff08\u542b\u4ee3\u53d1\u4e0e\u8d39\u7528\u62a5\u9500\uff09", (String)"B2EAgentQry_5", (String)"ebg-aqap-banks-fjnxs-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/B2EAgentQry.do?userPassword=" + RequestContextUtils.getBankParameterValue((String)"cif") + "&SIGDATA=1";
        factory.setUri(s);
    }
}

