/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bcs.dc.service.payment.salary;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bcs.dc.service.proxy.FileDownLoadUtil;
import kd.ebg.aqap.banks.bcs.dc.util.Common;
import kd.ebg.aqap.banks.bcs.dc.util.Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    EBGLogger log = EBGLogger.getInstance().getLogger(SalaryQueryPayImpl.class);

    public int getBatchSize() {
        return 500;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        String tr_code = "200201";
        String req_no = Sequence.genSequence();
        Element ap = Packer.createCommonHead(tr_code, req_no, "0");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfo.getPackageId());
        String serial_no = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"HRXJBSerialNo");
        if (StringUtils.isEmpty((String)serial_no)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u5e73\u53f0\u6d41\u6c34\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u786e\u8ba4\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"SalaryQueryPayImpl_7", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serial_no);
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)"");
        String d = paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)d);
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return Common.createCommonMsg(xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)(rspStr = Common.parseRecvMsg(rspStr)), (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryQueryPayImpl_0", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            String content;
            Element body = ap.getChild("body");
            String record_num = body.getChildTextTrim("record_num");
            String field_num = body.getChildTextTrim("field_num");
            int recordNum = -1;
            if (!StringUtils.isEmpty((String)record_num)) {
                recordNum = Integer.parseInt(record_num);
            }
            int fieldNum = -1;
            if (!StringUtils.isEmpty((String)field_num)) {
                fieldNum = Integer.parseInt(field_num);
            }
            if (recordNum < 1) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\uff0c\u94f6\u884c\u8fd4\u56de\u8bb0\u5f55\u6761\u6570=%s\u3002", (String)"SalaryQueryPayImpl_6", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]), record_num), (String)"", (String)"");
                return new EBBankPayResponse(paymentInfos);
            }
            String file_flag = head.getChildTextTrim("file_flag");
            if ("1".equals(file_flag)) {
                String file_name = body.getChildTextTrim("file_name");
                this.log.info("\u672c\u6b21[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u83b7\u53d6\u94f6\u884c\u63a8\u9001\u6587\u4ef6" + file_name);
                try {
                    FileDownLoadUtil fileUtil = new FileDownLoadUtil();
                    content = fileUtil.doBiz(file_name);
                }
                catch (Exception e) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u67e5\u8be2]\u83b7\u53d6\u94f6\u884c\u63a8\u9001\u6587\u4ef6\u5931\u8d25\u3002", (String)"SalaryQueryPayImpl_2", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]), (Throwable)e);
                }
            } else {
                this.log.info("\u672c\u6b21[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u54cd\u5e94\u62a5\u6587");
                content = body.getChildTextTrim("serial_record");
            }
            this.log.info("\u672c\u6b21[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u7684\u5177\u4f53\u5185\u5bb9\uff1a" + content);
            String[][] rs = this.parseRecord(content, recordNum, fieldNum);
            for (int i = 0; i < rs.length; ++i) {
                String ACNO = rs[i][1];
                String ACNAME = rs[i][3];
                String AMT = rs[i][5];
                String SUMMARY = rs[i][6];
                String STAT = rs[i][9];
                String ERR_MSG = rs[i][10];
                String BATCH_NO = rs[i][11];
                PaymentInfo payInfo = this.findPaymentInfo(paymentInfos, BATCH_NO, ACNO, ACNAME, AMT);
                if (null == payInfo) continue;
                if ("9".equals(STAT)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryQueryPayImpl_3", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]), (String)STAT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryQueryPayImpl_3", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]));
                    continue;
                }
                if ("6".equals(STAT)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryQueryPayImpl_4", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryQueryPayImpl_0", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private PaymentInfo findPaymentInfo(List<PaymentInfo> infos, String BATCH_NO, String ACNO, String ACNAME, String AMT) {
        String packageId = infos.get(0).getPackageId();
        for (PaymentInfo pay : infos) {
            if (!packageId.equals(BATCH_NO) || !pay.getIncomeAccNo().equals(ACNO) || !pay.getIncomeAccName().equals(ACNAME) || !pay.getAmount().toPlainString().equals(AMT)) continue;
            return pay;
        }
        return null;
    }

    private String[][] parseRecord(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        this.log.info("[\u4ee3\u53d1\u5de5\u8d44\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2] fieldNum =" + fieldNum + ", recordNum =" + recordNum + ", allrecord.length =" + allrecord.length);
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allrecord[(i + 1) * fieldNum + j];
            }
        }
        return r2;
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "200201";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u67e5\u8be2", (String)"SalaryQueryPayImpl_5", (String)"ebg-aqap-banks-bcs-dc", (Object[])new Object[0]);
    }
}

