/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hbnxs.dc.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hbnxs.dc.services.utils.HBNXS_Parser;
import kd.ebg.aqap.banks.hbnxs.dc.services.utils.HBNXS_headPacker;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element root = HBNXS_headPacker.buildHead(Sequence.gen14Sequence(), "3001");
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        String accNo = acnt.getAccNo();
        Element body = root.getChild("body");
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)accNo);
        return HBNXS_headPacker.getMsg(root, "003001");
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)HBNXS_Parser.getMsg(rspStr), (String)encoding);
        BankResponse bankRsp = HBNXS_Parser.parserHead(root);
        if (!"00000".equals(bankRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%s", (String)"BalanceImpl_5", (String)"ebg-aqap-banks-hbnxs-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{bankRsp.getResponseCode(), bankRsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = root.getChild("body");
        String account = body.getChildTextTrim("Account");
        String AccountName = body.getChildTextTrim("AcctName");
        String bal = body.getChildTextTrim("AcctBal");
        String totalAmount = body.getChildTextTrim("AcctBal");
        String accountStatus = body.getChildTextTrim("AcctStatus");
        if (!bankBalanceRequest.getAcnt().getAccNo().equals(account)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u53f7[%1$s]\u4e0e\u8fd4\u56de\u8d26\u53f7[%2$s]\u4e0d\u4e00\u81f4\u3002", (String)"BalanceImpl_6", (String)"ebg-aqap-banks-hbnxs-dc", (Object[])new Object[0]), bankBalanceRequest.getAcnt().getAccNo(), account));
        }
        BalanceInfo balance = new BalanceInfo();
        balance.setBankAcnt(bankBalanceRequest.getAcnt());
        balance.setBankCurrency(bankBalanceRequest.getBankCurrency());
        balance.setCurrentBalance(new BigDecimal(totalAmount));
        if (!StringUtils.isEmpty((String)bal)) {
            balance.setAvailableBalance(new BigDecimal(bal));
        }
        balance.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "003001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u5b9e\u65f6\u4f59\u989d\u67e5\u8be2(3001)", (String)"BalanceImpl_4", (String)"ebg-aqap-banks-hbnxs-dc", (Object[])new Object[0]);
    }
}

