/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hbnxs.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hbnxs.dc.services.utils.HBNXS_DCFileUtils;
import kd.ebg.aqap.banks.hbnxs.dc.services.utils.HBNXS_Parser;
import kd.ebg.aqap.banks.hbnxs.dc.services.utils.HBNXS_headPacker;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = HBNXS_headPacker.buildHead(Sequence.gen14Sequence(), "3002");
        BankAcnt acnt = bankDetailRequest.getAcnt();
        String accNo = acnt.getAccNo();
        Element body = root.getChild("body");
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"Xh", (String)"0000");
        return HBNXS_headPacker.getMsg(root, "003002");
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)HBNXS_Parser.getMsg(s), (String)encoding);
        BankResponse bankRsp = HBNXS_Parser.parserHead(root);
        if (!"00000".equals(bankRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :", (String)"DetailImpl_0", (String)"ebg-aqap-banks-hbnxs-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{bankRsp.getResponseCode(), bankRsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        Element body = root.getChild("body");
        String fileName = body.getChildText("FileName");
        String filePath = body.getChildText("FilePath");
        String str = "";
        HBNXS_DCFileUtils download = new HBNXS_DCFileUtils();
        str = download.downloadFile(fileName, filePath);
        logger.info("\u8bfb\u53d6\u5230\u7684\u660e\u7ec6\u5185\u5bb9\u4e3a\uff1a" + str);
        String[] lineStrings = str.split("\n");
        for (int i = 1; i < lineStrings.length; ++i) {
            String[] tempStrings = lineStrings[i].split("\\@\\|\\$");
            String transDate = tempStrings[1];
            String transTime = tempStrings[2];
            String oppacno = tempStrings[3];
            String payeeAcName = tempStrings[4];
            String payerAmount = tempStrings[5];
            String payeeAmount = tempStrings[6];
            String bal = tempStrings[7];
            String transNo = tempStrings[8];
            String summary = tempStrings[9];
            DetailInfo detail = new DetailInfo();
            if (StringUtils.isNotEmpty((String)transDate)) {
                LocalDate tDate = LocalDate.parse(transDate, DateTimeFormatter.ofPattern("yyyyMMdd"));
                detail.setTransDate(tDate);
                String dateTimeStr = "";
                dateTimeStr = StringUtils.isNotEmpty((String)transTime) ? transDate + transTime : transDate + "000000";
                LocalDateTime tDateTime = LocalDateTime.parse(dateTimeStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                detail.setTransTime(tDateTime);
            }
            detail.setAccNo(bankDetailRequest.getAcnt().getAccNo());
            detail.setCurrency(bankDetailRequest.getBankCurrency());
            detail.setBalance(new BigDecimal(bal));
            detail.setDebitAmount(new BigDecimal(payerAmount));
            detail.setCreditAmount(new BigDecimal(payeeAmount));
            detail.setOppAccNo(oppacno);
            detail.setOppAccName(payeeAcName);
            detail.setExplanation(summary);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("transDate", (Object)transDate);
            jsonObject.put("transNo", (Object)transNo);
            jsonObject.put("payerAmount", (Object)payerAmount);
            jsonObject.put("payeeAmount", (Object)payeeAmount);
            detail.setJsonMap(jsonObject.toString());
            detail.setBankDetailNo(transNo);
            detailList.add(detail);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "3002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u5f53\u65e5\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2(3002)", (String)"DetailImpl_1", (String)"ebg-aqap-banks-hbnxs-dc", (Object[])new Object[0]);
    }
}

