/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hbnxs.dc.services.payment;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hbnxs.dc.services.utils.HBNXS_Parser;
import kd.ebg.aqap.banks.hbnxs.dc.services.utils.HBNXS_headPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(QryPaymentImpl.class);

    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = HBNXS_headPacker.buildHead(paymentInfo.getBankDetailSeqId(), "1002");
        Element body = root.getChild("body");
        JDomUtils.addChild((Element)body, (String)"OldTxDate", (String)paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"OldSeqNo", (String)paymentInfo.getBankDetailSeqId());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)s, (String)encoding);
        BankResponse bankRsp = HBNXS_Parser.parserHead(root);
        if (!"00000".equals(bankRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QryPaymentImpl_0", (String)"ebg-aqap-banks-hbnxs-dc", (Object[])new Object[0]), (String)bankRsp.getResponseCode(), (String)bankRsp.getResponseMessage());
        } else {
            Element body = root.getChild("body");
            String TxStatus = body.getChildText("TxStatus");
            if ("0".equals(TxStatus)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QryPaymentImpl_1", (String)"ebg-aqap-banks-hbnxs-dc", (Object[])new Object[0]), (String)TxStatus, (String)bankRsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QryPaymentImpl_2", (String)"ebg-aqap-banks-hbnxs-dc", (Object[])new Object[0]), (String)TxStatus, (String)bankRsp.getResponseMessage());
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "1002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u7ed3\u679c\u67e5\u8be2(1002)", (String)"QryPaymentImpl_3", (String)"ebg-aqap-banks-hbnxs-dc", (Object[])new Object[0]);
    }
}

