/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hbnxs.dc.services.utils;

import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class DESUtil {
    public static byte[] hex(String key) {
        String f = DigestUtils.md5Hex((String)key);
        byte[] bkeys = f.getBytes();
        byte[] enk = Arrays.copyOf(bkeys, 24);
        return enk;
    }

    public static String encode3Des(String key, String srcStr) {
        byte[] keybyte = DESUtil.hex(key);
        byte[] src = srcStr.getBytes();
        try {
            SecretKeySpec deskey = new SecretKeySpec(keybyte, "AES");
            Cipher c1 = Cipher.getInstance("AES/GCM/NoPadding");
            c1.init(1, deskey);
            String pwd = Base64.encodeBase64String((byte[])c1.doFinal(src));
            return pwd;
        }
        catch (Exception e1) {
            EBExceiptionUtil.serviceException((Throwable)e1);
            return null;
        }
    }

    public static String decode3Des(String key, String desStr) {
        Base64 base64 = new Base64();
        byte[] keybyte = DESUtil.hex(key);
        byte[] src = base64.decode(desStr);
        try {
            SecretKeySpec deskey = new SecretKeySpec(keybyte, "AES");
            Cipher c1 = Cipher.getInstance("AES/GCM/NoPadding");
            c1.init(2, deskey);
            return new String(c1.doFinal(src));
        }
        catch (Exception e1) {
            EBExceiptionUtil.serviceException((Throwable)e1);
            return null;
        }
    }

    public static String getCA(String id) {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID(id, RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getCustomId());
        if (certInfo == null) {
            return "";
        }
        CipherInfo cipherInfo = DESUtil.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return StringUtils.byteToString((byte[])fileContent);
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(java.util.Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }
}

