/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xjnx.dc.service.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xjnx.dc.service.util.Packer;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        return Packer.getHead() + "accountNo=" + bankBalanceRequest.getAcnt().getAccNo();
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element ebank = JDomUtils.string2Root((String)rspStr, (String)encoding);
        String retcode = ebank.getChildText("retCode");
        if ("000000".equalsIgnoreCase(retcode)) {
            String balanceFreeze;
            EBBankBalanceResponse balanceRsp = new EBBankBalanceResponse();
            BalanceInfo balanceInfo = new BalanceInfo();
            String balance = ebank.getChildText("balance");
            if (StringUtils.isEmpty((String)balance)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4f59\u989d\u5b57\u6bb5\u4e3a\u7a7a", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-xjnx-dc", (Object[])new Object[0]));
            }
            String currencyType = ebank.getChildTextTrim("currencyType");
            balanceInfo.setCurrentBalance(new BigDecimal(ebank.getChildText("balance")));
            String balanceAvailable = ebank.getChildText("balanceAvailable");
            if (StringUtils.isNotEmpty((String)balanceAvailable)) {
                balanceInfo.setAvailableBalance(new BigDecimal(balanceAvailable));
            }
            if (StringUtils.isNotEmpty((String)(balanceFreeze = ebank.getChildTextTrim("balanceFreeze")))) {
                balanceInfo.setFreezeBalance(new BigDecimal(balanceFreeze));
            }
            balanceInfo.setBankCurrency(currencyType);
            balanceInfo.setBankAcnt(rqst.getAcnt());
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            balanceRsp.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
            return balanceRsp;
        }
        String retMessage = ebank.getChildText("retMessage");
        String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-xjnx-dc", (Object[])new Object[0]), retcode, retMessage);
        throw EBExceiptionUtil.serviceException((String)resMsg);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "YQqryBalancyAction";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        String uri = RequestContextUtils.getBankParameterValue((String)"xjnx_uri");
        factory.setUri(uri + "/YQqryBalancyAction");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }
}

