/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xjnx.dc.service.payment.inner;

import java.util.List;
import kd.ebg.aqap.banks.xjnx.dc.service.payment.QueryPaymentImpl;
import kd.ebg.aqap.banks.xjnx.dc.service.util.Packer;
import kd.ebg.aqap.banks.xjnx.dc.service.util.SignUtils;
import kd.ebg.aqap.banks.xjnx.dc.service.util.XJNXTransferParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class InnerPaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        String str = RequestContextUtils.getBankParameterValue((String)"userId") + "|" + paymentInfo.getAccNo() + "|" + paymentInfo.getIncomeAccNo() + "|" + paymentInfo.getAmount() + "|" + paymentInfo.getBankDetailSeqId();
        String signData = SignUtils.getInstance().sendAndRecvMsg(str);
        String newStr = Packer.getHead() + "payAccount=" + paymentInfo.getAccNo() + "&recAccount=" + paymentInfo.getIncomeAccNo() + "&recAccountName=" + paymentInfo.getIncomeAccName() + "&paybookAccType=" + (paymentInfo.is2Individual() ? "1" : "2") + "&payAmount=" + paymentInfo.getAmount() + "&remark=" + paymentInfo.getExplanation() + "&payUse=" + paymentInfo.getExplanation() + "&cbTransferNo=" + paymentInfo.getBankDetailSeqId() + "&signData=" + signData;
        return newStr;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String paramString) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        XJNXTransferParser.parseTransfer(paymentInfos, paramString);
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        String uri = RequestContextUtils.getBankParameterValue((String)"xjnx_uri");
        factory.setUri(uri + "/YQinnerTransAction");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "YQinnerTransAction";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

