/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.anz.dc.service.payment.oversea.hk;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.anz.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.anz.dc.service.payment.oversea.Helper;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HK_CommonPacker {
    public static Element packPayXmlhead(PaymentInfo[] paymentInfos, Element CstmrCdtTrfInitn, Namespace ns1) {
        PaymentInfo paymentInfo = paymentInfos[0];
        Element GrpHdr = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"GrpHdr").setNamespace(ns1);
        JDomUtils.addChild((Element)GrpHdr, (String)"use", (String)paymentInfo.getUseCn()).setNamespace(ns1);
        JDomUtils.addChild((Element)GrpHdr, (String)"MsgId", (String)paymentInfo.getBankBatchSeqId()).setNamespace(ns1);
        JDomUtils.addChild((Element)GrpHdr, (String)"CreDtTm", (String)HK_CommonPacker.now()).setNamespace(ns1);
        Element NbOfTxs = JDomUtils.addChild((Element)GrpHdr, (String)"NbOfTxs").setNamespace(ns1);
        NbOfTxs.addContent(String.valueOf(paymentInfos.length));
        JDomUtils.addChild((Element)GrpHdr, (String)"CtrlSum").setNamespace(ns1);
        Element InitgPty = JDomUtils.addChild((Element)GrpHdr, (String)"InitgPty").setNamespace(ns1);
        JDomUtils.addChild((Element)InitgPty, (String)"Nm", (String)paymentInfo.getAccName()).setNamespace(ns1);
        return GrpHdr;
    }

    public static Element packPayXmlPmtInfo(PaymentInfo[] paymentInfos, Element CstmrCdtTrfInitn) {
        LocalDateTime bookingTime;
        Element SvcLvl;
        PaymentInfo paymentInfo = paymentInfos[0];
        String accNo = paymentInfo.getAccNo();
        String use = paymentInfo.getUseCn();
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Element PmtInf = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"PmtInf").setNamespace(ns1);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtInfId", (String)paymentInfo.getBankBatchSeqId()).setNamespace(ns1);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtMtd", (String)"TRF").setNamespace(ns1);
        Element PmtTpInf = JDomUtils.addChild((Element)PmtInf, (String)"PmtTpInf").setNamespace(ns1);
        String payPurpose = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"payPurpose");
        if (!StringUtils.isEmpty((String)payPurpose)) {
            if ("SALA".equalsIgnoreCase(payPurpose)) {
                Element CtgyPurp = JDomUtils.addChild((Element)PmtTpInf, (String)"CtgyPurp").setNamespace(ns1);
                JDomUtils.addChild((Element)CtgyPurp, (String)"Cd", (String)payPurpose).setNamespace(ns1);
            } else if ("FPS".equalsIgnoreCase(use)) {
                SvcLvl = JDomUtils.addChild((Element)PmtTpInf, (String)"SvcLvl").setNamespace(ns1);
                JDomUtils.addChild((Element)SvcLvl, (String)"Cd", (String)"URNS").setNamespace(ns1);
                Element CtgyPurp = JDomUtils.addChild((Element)PmtTpInf, (String)"CtgyPurp").setNamespace(ns1);
                JDomUtils.addChild((Element)CtgyPurp, (String)"Prtry", (String)payPurpose).setNamespace(ns1);
            }
        }
        if ("RTGS".equalsIgnoreCase(use)) {
            JDomUtils.addChild((Element)PmtTpInf, (String)"InstrPrty", (String)"HIGH").setNamespace(ns1);
            SvcLvl = JDomUtils.addChild((Element)PmtTpInf, (String)"SvcLvl").setNamespace(ns1);
            JDomUtils.addChild((Element)SvcLvl, (String)"Cd", (String)"URGP").setNamespace(ns1);
        }
        if ((bookingTime = paymentInfo.getBookingTime()) == null) {
            bookingTime = LocalDateTime.now();
        }
        JDomUtils.addChild((Element)PmtInf, (String)"ReqdExctnDt", (String)bookingTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).setNamespace(ns1);
        PaymentUtil.setBookPayFlag((PaymentInfo[])paymentInfos);
        Element Dbtr = JDomUtils.addChild((Element)PmtInf, (String)"Dbtr").setNamespace(ns1);
        String name = BankBusinessConfig.getPayCompany(accNo);
        if (StringUtils.isEmpty((String)name)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u4e91\u5e10\u53f7\u7ba1\u7406-\u9644\u52a0\u5c5e\u6027\u4e2d\u7ef4\u62a4\u3002", (String)"HK_CommonPacker_0", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)Dbtr, (String)"Nm", (String)name).setNamespace(ns1);
        Element PstlAdr = JDomUtils.addChild((Element)Dbtr, (String)"PstlAdr").setNamespace(ns1);
        Helper helper = new Helper();
        helper.addressSplit(PstlAdr, BankBusinessConfig.getPayCompanyStreet(accNo), ns1);
        Element DbtrAcct = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAcct").setNamespace(ns1);
        Element DbtrAcct_Id = JDomUtils.addChild((Element)DbtrAcct, (String)"Id").setNamespace(ns1);
        Element DbtrAcct_Othr = JDomUtils.addChild((Element)DbtrAcct_Id, (String)"Othr").setNamespace(ns1);
        JDomUtils.addChild((Element)DbtrAcct_Othr, (String)"Id", (String)accNo).setNamespace(ns1);
        Element DbtrAgt = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAgt").setNamespace(ns1);
        Element FinInstnId = JDomUtils.addChild((Element)DbtrAgt, (String)"FinInstnId").setNamespace(ns1);
        String bic = BankBusinessConfig.getBicCode(accNo);
        if (StringUtils.isEmpty((String)bic)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c\u7684BIC swift code\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u4e91\u5e10\u53f7\u7ba1\u7406-\u9644\u52a0\u5c5e\u6027\u4e2d\u7ef4\u62a4\u3002", (String)"HK_CommonPacker_1", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)FinInstnId, (String)"BIC", (String)bic).setNamespace(ns1);
        Element FinInstnId_PstlAdr = JDomUtils.addChild((Element)FinInstnId, (String)"PstlAdr").setNamespace(ns1);
        String ctry = BankBusinessConfig.getBankCity(accNo);
        if (StringUtils.isEmpty((String)ctry)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c\u56fd\u5bb6/\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u4e91\u5e10\u53f7\u7ba1\u7406-\u9644\u52a0\u5c5e\u6027\u4e2d\u7ef4\u62a4\u3002", (String)"HK_CommonPacker_2", (String)"ebg-aqap-banks-anz-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)FinInstnId_PstlAdr, (String)"Ctry", (String)ctry).setNamespace(ns1);
        return PmtInf;
    }

    private static String now() {
        return DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss").replace(' ', 'T');
    }
}

