/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jjccb.cmp.services.balance;

import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jjccb.cmp.services.util.Common;
import kd.ebg.aqap.banks.jjccb.cmp.services.util.Packer;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        String req_no = RequestContextUtils.getRequestContext().getBankRequestSeq();
        String tr_code = "200108";
        Element ap = Packer.createCommonHead(tr_code, req_no, "0");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)bankBalanceRequest.getBankCurrency());
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDecAndPrettyFormat((Element)ap, (String)encoding);
        xmlMsg = Common.createCommonMsg(xmlMsg);
        return xmlMsg;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ap.getChild("head");
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s ,%2$s", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-jjccb-cmp", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        String tr_acdt = head.getChildTextTrim("tr_acdt");
        String tr_time = head.getChildTextTrim("tr_time");
        Element body = ap.getChild("body");
        String acno = body.getChildTextTrim("acno");
        String cur_code = body.getChildTextTrim("cur_code");
        String acname = body.getChildTextTrim("acname");
        String balance = body.getChildTextTrim("balance");
        String use_balance = body.getChildTextTrim("use_balance");
        String freeze_bal = body.getChildTextTrim("freeze_bal");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
        balanceInfo.setBankCurrency(cur_code);
        try {
            balanceInfo.setBalanceDateTime(LocalDateTime.parse(tr_acdt + tr_time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!StringUtils.isEmpty((String)balance)) {
            balanceInfo.setCurrentBalance(new BigDecimal(balance));
        } else {
            balanceInfo.setError(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"BalanceImpl_3", (String)"ebg-aqap-banks-jjccb-cmp", (Object[])new Object[0]));
        }
        if (!StringUtils.isEmpty((String)use_balance)) {
            balanceInfo.setAvailableBalance(new BigDecimal(use_balance));
        }
        balanceInfos.add(balanceInfo);
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "200108";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-jjccb-cmp", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}

