/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.dc.services.detail;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zsb.dc.services.ZSB_DC_Packer;
import kd.ebg.aqap.banks.zsb.dc.services.ZSB_DC_Parser;
import kd.ebg.aqap.banks.zsb.dc.services.detail.DetailParse;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HistoryDetailImpl
extends AbstractDetailImpl
implements IHisDetail {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HistoryDetailImpl.class);

    public String pack(BankDetailRequest request) throws EBServiceException {
        Element root = ZSB_DC_Packer.buildHead("200110", RequestContextUtils.getRequestContext().getBankRequestSeq());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return ZSB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        return new EBBankDetailResponse(DetailParse.getInstance().parseHisDetail(request, responseStr));
    }

    public String getDeveloper() {
        return "mukan_huang";
    }

    public String getBizCode() {
        return "200110";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d59\u5546\u94f6\u884c\u67e5\u8be2\u5386\u53f2\u4ea4\u6613\u660e\u7ec6", (String)"HistoryDetailImpl_0", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.doBiz(request);
    }

    public String recv(InputStream inputStream) {
        return ZSB_DC_Parser.parseRecvMsg(super.recv(inputStream));
    }
}

