/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.dc.services.payment.company;

import java.io.InputStream;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zsb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.zsb.dc.services.ZSB_DC_Packer;
import kd.ebg.aqap.banks.zsb.dc.services.ZSB_DC_Parser;
import kd.ebg.aqap.banks.zsb.dc.services.payment.company.CompanyPayQueryImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyPayImpl
extends AbstractPayImpl
implements IPay {
    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyPayQueryImpl.class;
    }

    public String getDeveloper() {
        return "mukan_huang";
    }

    public String getBizCode() {
        return "300001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d59\u5546\u94f6\u884c\u5bf9\u516c\u652f\u4ed8", (String)"CompanyPayImpl_0", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u7684'\u5bf9\u5916\u652f\u4ed8 (300001\u4ea4\u6613)'\u63a5\u53e3\u4e0d\u652f\u6301\u6279\u91cf", (String)"CompanyPayImpl_1", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = ZSB_DC_Packer.buildHead("300001", paymentInfo.getPackageId());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"pay_accaddr", (String)"");
        JDomUtils.addChild((Element)body, (String)"cert_type", (String)"");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)"");
        JDomUtils.addChild((Element)body, (String)"rcv_acno", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcv_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"rcv_acname", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"rcv_accaddr", (String)"");
        JDomUtils.addChild((Element)body, (String)"rcv_bank_no", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"rcv_bank_name", (String)paymentInfo.getIncomeBankName());
        String amount = paymentInfo.getAmount().setScale(2, 1).toString();
        JDomUtils.addChild((Element)body, (String)"amt", (String)amount);
        JDomUtils.addChild((Element)body, (String)"bank_flag", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"urgency_flag", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)body, (String)"area_flag", (String)(paymentInfo.is2SameCity() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"bank_kind", (String)"");
        JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfo.getExplanation());
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            JDomUtils.addChild((Element)body, (String)"postscript", (String)(paymentInfo.getBankDetailSeqId() + "KD@"));
        } else {
            JDomUtils.addChild((Element)body, (String)"postscript", (String)"");
        }
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return ZSB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = ZSB_DC_Parser.parseResponeCode(root);
        if ("0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyPayImpl_2", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyPayImpl_3", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String recv(InputStream inputStream) {
        return ZSB_DC_Parser.parseRecvMsg(super.recv(inputStream));
    }
}

