/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.dc.services.proxy;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.HttpConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FrontProxy
extends AbstractImpl {
    public Element createHead(String bizType) throws EBServiceException {
        return this.createHead(bizType, Sequence.genSequence());
    }

    public Element createHead(String bizType, String seqno) throws EBServiceException {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)DateTimeUtils.format((Date)new Date(), (String)"HHmmss"));
        JDomUtils.addChild((Element)head, (String)"bizType", (String)bizType);
        JDomUtils.addChild((Element)head, (String)"sequence", (String)seqno);
        return head;
    }

    public BankResponse parseHeader(Element root) throws EBServiceException {
        Element Head = JDomUtils.getChildElementNotNull((Element)root, (String)"head");
        String IBSReturnCode = JDomUtils.getChildTextNotNull((Element)Head, (String)"rspcode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"FrontProxy_0", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Head, (String)"rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }

    public String sendAndRecvMsg(String rqstStr) throws EBServiceException, Exception {
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String portStr = RequestContextUtils.getBankParameterValue((String)"frontProxy_Port");
        String timeOutStr = RequestContextUtils.getBankParameterValue((String)"timeout");
        int port = Integer.parseInt(portStr);
        int timeOut = Integer.parseInt(timeOutStr);
        String rspStr = "";
        if (!EBContext.getContext().isUnitTest()) {
            try {
                HashMap header = new HashMap(16);
                HttpConnection conn = new HttpConnection(ip, port, "", header, timeOut);
                this.openConnection((IConnection)conn);
                try (OutputStream os = this.getOutputStream((IConnection)conn);){
                    this.send(os, rqstStr);
                    try (InputStream is = this.getInputStream((IConnection)conn);){
                        rspStr = this.recv(is);
                    }
                }
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        return rspStr;
    }
}

